/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.metrics;

import com.yammer.metrics.Metrics;
import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.MetricName;
import com.yammer.metrics.core.Timer;
import java.util.concurrent.TimeUnit;
import org.apache.cassandra.db.commitlog.AbstractCommitLogService;
import org.apache.cassandra.db.commitlog.CommitLogSegmentManager;
import org.apache.cassandra.metrics.DefaultNameFactory;
import org.apache.cassandra.metrics.MetricNameFactory;

public class CommitLogMetrics {
    public static final MetricNameFactory factory = new DefaultNameFactory("CommitLog");
    public final Gauge<Long> completedTasks;
    public final Gauge<Long> pendingTasks;
    public final Gauge<Long> totalCommitLogSize;
    public final Timer waitingOnSegmentAllocation;
    public final Timer waitingOnCommit;

    public CommitLogMetrics(final AbstractCommitLogService service, final CommitLogSegmentManager allocator) {
        this.completedTasks = Metrics.newGauge((MetricName)factory.createMetricName("CompletedTasks"), (Gauge)new Gauge<Long>(){

            public Long value() {
                return service.getCompletedTasks();
            }
        });
        this.pendingTasks = Metrics.newGauge((MetricName)factory.createMetricName("PendingTasks"), (Gauge)new Gauge<Long>(){

            public Long value() {
                return service.getPendingTasks();
            }
        });
        this.totalCommitLogSize = Metrics.newGauge((MetricName)factory.createMetricName("TotalCommitLogSize"), (Gauge)new Gauge<Long>(){

            public Long value() {
                return allocator.bytesUsed();
            }
        });
        this.waitingOnSegmentAllocation = Metrics.newTimer((MetricName)factory.createMetricName("WaitingOnSegmentAllocation"), (TimeUnit)TimeUnit.MICROSECONDS, (TimeUnit)TimeUnit.SECONDS);
        this.waitingOnCommit = Metrics.newTimer((MetricName)factory.createMetricName("WaitingOnCommit"), (TimeUnit)TimeUnit.MICROSECONDS, (TimeUnit)TimeUnit.SECONDS);
    }
}

