/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.spring.boot;

import java.util.Map;
import org.apache.camel.LoggingLevel;
import org.apache.camel.ManagementMBeansLevel;
import org.apache.camel.ManagementStatisticsLevel;
import org.apache.camel.StartupSummaryLevel;
import org.apache.camel.main.DefaultConfigurationProperties;
import org.springframework.boot.context.properties.ConfigurationProperties;

@ConfigurationProperties(prefix="camel.springboot")
public class CamelConfigurationProperties
extends DefaultConfigurationProperties<CamelConfigurationProperties> {
    private boolean mainRunController;
    private boolean includeNonSingletons;
    private boolean warnOnEarlyShutdown = true;
    private String name;
    private String description;
    private StartupSummaryLevel startupSummaryLevel = StartupSummaryLevel.Default;
    private int shutdownTimeout = 300;
    private boolean shutdownSuppressLoggingOnTimeout;
    private boolean shutdownNowOnTimeout = true;
    private boolean shutdownRoutesInReverseOrder = true;
    private boolean shutdownLogInflightExchangesOnTimeout = true;
    private String uuidGenerator = "default";
    private boolean jmxEnabled = true;
    private int producerTemplateCacheSize = 1000;
    private int consumerTemplateCacheSize = 1000;
    private boolean modeline;
    private boolean devConsoleEnabled;
    private boolean loadTypeConverters = true;
    private boolean loadHealthChecks;
    private String compileWorkDir;
    private String fileConfigurations;
    private String routeFilterIncludePattern;
    private String routeFilterExcludePattern;
    private boolean routesReloadEnabled;
    private String routesReloadDirectory = "src/main/resources";
    private boolean routesReloadDirectoryRecursive;
    private String routesReloadPattern = "camel/*";
    private boolean routesReloadRemoveAllRoutes = true;
    private boolean routesReloadRestartDuration;
    private int durationMaxSeconds;
    private int durationMaxIdleSeconds;
    private int durationMaxMessages;
    private String durationMaxAction = "shutdown";
    private int logDebugMaxChars;
    private boolean streamCachingEnabled = true;
    private String streamCachingAllowClasses;
    private String streamCachingDenyClasses;
    private boolean streamCachingSpoolEnabled;
    private String streamCachingSpoolDirectory;
    private String streamCachingSpoolCipher;
    private long streamCachingSpoolThreshold;
    private int streamCachingSpoolUsedHeapMemoryThreshold;
    private String streamCachingSpoolUsedHeapMemoryLimit;
    private boolean streamCachingAnySpoolRules;
    private int streamCachingBufferSize;
    private boolean streamCachingRemoveSpoolDirectoryWhenStopping = true;
    private boolean streamCachingStatisticsEnabled;
    private boolean typeConverterStatisticsEnabled;
    private boolean backlogTracing;
    private boolean backlogTracingStandby;
    private boolean backlogTracingTemplates;
    private boolean tracing;
    private boolean tracingStandby;
    private boolean tracingTemplates;
    private String tracingPattern;
    private String tracingLoggingFormat;
    private boolean messageHistory = true;
    private boolean sourceLocationEnabled;
    private boolean logMask;
    private boolean logExhaustedMessageBody;
    private boolean autoStartup = true;
    private boolean allowUseOriginalMessage;
    private boolean caseInsensitiveHeaders = true;
    private boolean autowiredEnabled = true;
    private boolean inflightRepositoryBrowseEnabled;
    private boolean endpointRuntimeStatisticsEnabled;
    private boolean loadStatisticsEnabled;
    public boolean endpointBridgeErrorHandler;
    public boolean endpointBasicPropertyBinding;
    private boolean endpointLazyStartProducer;
    private boolean useDataType;
    private boolean useBreadcrumb;
    private boolean beanPostProcessorEnabled = true;
    private boolean allowAddingNewRoutes = true;
    private ManagementMBeansLevel jmxManagementMBeansLevel = ManagementMBeansLevel.Default;
    private ManagementStatisticsLevel jmxManagementStatisticsLevel = ManagementStatisticsLevel.Default;
    private String jmxManagementNamePattern = "#name#";
    private boolean jmxUpdateRouteEnabled;
    private String dumpRoutes;
    private String dumpRoutesInclude = "routes";
    private boolean dumpRoutesLog = true;
    private boolean dumpRoutesResolvePlaceholders = true;
    private boolean dumpRoutesGeneratedIds;
    private boolean dumpRoutesUriAsParameters;
    private String dumpRoutesOutput;
    private Map<String, String> globalOptions;
    private boolean camelEventsTimestampEnabled;
    private boolean useMdcLogging;
    private String mdcLoggingKeysPattern;
    private String threadNamePattern;
    private boolean beanIntrospectionExtendedStatistics;
    private boolean contextReloadEnabled;
    private LoggingLevel beanIntrospectionLoggingLevel;
    private boolean routesCollectorEnabled = true;
    private boolean routesCollectorIgnoreLoadingError;
    private String routesIncludePattern = "classpath:camel/*,classpath:camel-template/*,classpath:camel-rest/*";
    private String routesExcludePattern;
    private String javaRoutesIncludePattern;
    private String javaRoutesExcludePattern;
    private boolean lightweight;
    private String exchangeFactory = "default";
    private int exchangeFactoryCapacity = 100;
    private boolean exchangeFactoryStatisticsEnabled;
    private String startupRecorder;
    private int startupRecorderMaxDepth = -1;
    private boolean startupRecorderRecording;
    private String startupRecorderProfile = "default";
    private long startupRecorderDuration;
    private String startupRecorderDir;

    public boolean isMainRunController() {
        return this.mainRunController;
    }

    public void setMainRunController(boolean mainRunController) {
        this.mainRunController = mainRunController;
    }

    public boolean isIncludeNonSingletons() {
        return this.includeNonSingletons;
    }

    public void setIncludeNonSingletons(boolean includeNonSingletons) {
        this.includeNonSingletons = includeNonSingletons;
    }

    public boolean isWarnOnEarlyShutdown() {
        return this.warnOnEarlyShutdown;
    }

    public void setWarnOnEarlyShutdown(boolean warnOnEarlyShutdown) {
        this.warnOnEarlyShutdown = warnOnEarlyShutdown;
    }
}

