/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.spring.boot;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import org.apache.camel.impl.engine.DefaultPackageScanResourceResolver;
import org.apache.camel.util.IOHelper;
import org.apache.camel.util.StringHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FatJarPackageScanResourceResolver
extends DefaultPackageScanResourceResolver {
    private static final Logger LOG = LoggerFactory.getLogger(FatJarPackageScanResourceResolver.class);
    private static final String SPRING_BOOT_CLASSIC_LIB_ROOT = "lib/";
    private static final String SPRING_BOOT_BOOT_INF_LIB_ROOT = "BOOT-INF/lib/";
    private static final String SPRING_BOOT_BOOT_INF_CLASSES_ROOT = "BOOT-INF/classes/";
    private static final String SPRING_BOOT_WEB_INF_LIB_ROOT = "WEB-INF/lib/";
    private static final String SPRING_BOOT_WEB_INF_CLASSES_ROOT = "WEB-INF/classes/";

    protected List<String> doLoadImplementationsInJar(String packageName, InputStream stream, String urlPath) {
        return this.doLoadImplementationsInJar(packageName, stream, urlPath, true, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<String> doLoadImplementationsInJar(String packageName, InputStream stream, String urlPath, boolean inspectNestedJars, boolean closeStream) {
        ArrayList<String> entries = new ArrayList<String>();
        JarInputStream jarStream = null;
        try {
            JarEntry entry;
            jarStream = new JarInputStream(stream);
            while ((entry = jarStream.getNextJarEntry()) != null) {
                String name = entry.getName().trim();
                if (inspectNestedJars && !entry.isDirectory() && this.isSpringBootNestedJar(name)) {
                    String nestedUrl = urlPath + "!/" + name;
                    LOG.trace("Inspecting nested jar: {}", (Object)nestedUrl);
                    List<String> nestedEntries = this.doLoadImplementationsInJar(packageName, jarStream, nestedUrl, false, false);
                    entries.addAll(nestedEntries);
                    continue;
                }
                if (entry.isDirectory() || name.endsWith(".class") || !(name = this.cleanupSpringBootClassName(name)).startsWith(packageName)) continue;
                entries.add(name);
            }
        }
        catch (IOException ioe) {
            LOG.warn("Cannot search jar file '" + urlPath + " due to an IOException: " + ioe.getMessage() + ". This exception is ignored.", (Throwable)ioe);
        }
        finally {
            if (closeStream) {
                IOHelper.close((Closeable)jarStream, (String)urlPath, (Logger)LOG);
            }
        }
        return entries;
    }

    protected String parseUrlPath(URL url) {
        block4: {
            String nested;
            String urlPath = url.getFile();
            urlPath = URLDecoder.decode(urlPath, StandardCharsets.UTF_8);
            if (LOG.isTraceEnabled()) {
                LOG.trace("Decoded urlPath: {} with protocol: {}", (Object)urlPath, (Object)url.getProtocol());
            }
            if (urlPath.startsWith(nested = "nested:")) {
                try {
                    urlPath = new URI(url.getFile()).getPath();
                    return StringHelper.before((String)urlPath, (String)"!", (String)urlPath);
                }
                catch (URISyntaxException uRISyntaxException) {
                    if (!urlPath.startsWith(nested)) break block4;
                    urlPath = urlPath.substring(nested.length());
                    return StringHelper.before((String)urlPath, (String)"!", (String)urlPath);
                }
            }
        }
        return super.parseUrlPath(url);
    }

    private boolean isSpringBootNestedJar(String name) {
        return name.endsWith(".jar") && (name.startsWith(SPRING_BOOT_CLASSIC_LIB_ROOT) || name.startsWith(SPRING_BOOT_BOOT_INF_LIB_ROOT) || name.startsWith(SPRING_BOOT_WEB_INF_LIB_ROOT));
    }

    private String cleanupSpringBootClassName(String name) {
        if (name.startsWith(SPRING_BOOT_BOOT_INF_CLASSES_ROOT)) {
            name = name.substring(SPRING_BOOT_BOOT_INF_CLASSES_ROOT.length());
        }
        if (name.startsWith(SPRING_BOOT_WEB_INF_CLASSES_ROOT)) {
            name = name.substring(SPRING_BOOT_WEB_INF_CLASSES_ROOT.length());
        }
        return name;
    }
}

