/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.spring.boot;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.ConsumerTemplate;
import org.apache.camel.FluentProducerTemplate;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.Service;
import org.apache.camel.component.properties.PropertiesParser;
import org.apache.camel.main.DefaultConfigurationConfigurer;
import org.apache.camel.main.DefaultConfigurationProperties;
import org.apache.camel.main.DefaultRoutesCollector;
import org.apache.camel.main.RoutesCollector;
import org.apache.camel.model.Model;
import org.apache.camel.spi.BeanRepository;
import org.apache.camel.spi.CliConnector;
import org.apache.camel.spi.CliConnectorFactory;
import org.apache.camel.spi.PackageScanClassResolver;
import org.apache.camel.spi.PackageScanResourceResolver;
import org.apache.camel.spi.PropertiesComponent;
import org.apache.camel.spi.Registry;
import org.apache.camel.spi.StartupStepRecorder;
import org.apache.camel.spring.boot.CamelConfigurationProperties;
import org.apache.camel.spring.boot.CamelContextConfiguration;
import org.apache.camel.spring.boot.CamelSpringBootApplicationController;
import org.apache.camel.spring.boot.CamelSpringBootApplicationListener;
import org.apache.camel.spring.boot.CamelSpringBootBeanPostProcessor;
import org.apache.camel.spring.boot.FatJarPackageScanClassResolver;
import org.apache.camel.spring.boot.FatJarPackageScanResourceResolver;
import org.apache.camel.spring.boot.FilePropertySource;
import org.apache.camel.spring.boot.SpringBootCamelContext;
import org.apache.camel.spring.boot.SpringPropertiesParser;
import org.apache.camel.spring.boot.TypeConversionConfiguration;
import org.apache.camel.spring.boot.aot.CamelRuntimeHints;
import org.apache.camel.spring.spi.ApplicationContextBeanRepository;
import org.apache.camel.spring.spi.CamelBeanPostProcessor;
import org.apache.camel.support.DefaultRegistry;
import org.apache.camel.support.service.ServiceHelper;
import org.apache.camel.support.startup.LoggingStartupStepRecorder;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingClass;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.ImportRuntimeHints;
import org.springframework.context.annotation.Lazy;
import org.springframework.context.annotation.Role;
import org.springframework.core.OrderComparator;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertySource;

@ImportRuntimeHints(value={CamelRuntimeHints.class})
@Configuration(proxyBeanMethods=false)
@EnableConfigurationProperties(value={CamelConfigurationProperties.class})
@Import(value={TypeConversionConfiguration.class})
@Role(value=2)
public class CamelAutoConfiguration {
    private static final Logger LOG = LoggerFactory.getLogger(CamelAutoConfiguration.class);

    @Bean(destroyMethod="")
    @ConditionalOnMissingBean(value={CamelContext.class})
    CamelContext camelContext(ApplicationContext applicationContext, CamelConfigurationProperties config, CamelBeanPostProcessor beanPostProcessor) throws Exception {
        SpringBootCamelContext camelContext = new SpringBootCamelContext(applicationContext, config.isWarnOnEarlyShutdown());
        beanPostProcessor.setCamelContext((CamelContext)camelContext);
        camelContext.getCamelContextExtension().addContextPlugin(CamelBeanPostProcessor.class, (Object)beanPostProcessor);
        return CamelAutoConfiguration.doConfigureCamelContext(applicationContext, (CamelContext)camelContext, config);
    }

    public static CamelContext doConfigureCamelContext(ApplicationContext applicationContext, CamelContext camelContext, CamelConfigurationProperties config) throws Exception {
        MutablePropertySources sources;
        Environment env;
        Map repositories;
        CamelAutoConfiguration.configureStartupRecorder(camelContext, config);
        camelContext.build();
        org.apache.camel.component.properties.PropertiesComponent pc = (org.apache.camel.component.properties.PropertiesComponent)applicationContext.getBeanProvider(org.apache.camel.component.properties.PropertiesComponent.class).getIfAvailable();
        if (pc != null) {
            pc.setCamelContext(camelContext);
            camelContext.setPropertiesComponent((PropertiesComponent)pc);
        }
        if (!(repositories = applicationContext.getBeansOfType(BeanRepository.class)).isEmpty()) {
            ArrayList<Object> reps = new ArrayList<Object>();
            reps.add(new ApplicationContextBeanRepository(applicationContext));
            reps.addAll(repositories.values());
            OrderComparator.sort(reps);
            camelContext.getCamelContextExtension().setRegistry((Registry)new DefaultRegistry(reps));
        }
        if (ObjectHelper.isNotEmpty((String)config.getFileConfigurations()) && (env = applicationContext.getEnvironment()) instanceof ConfigurableEnvironment && !(sources = ((ConfigurableEnvironment)env).getPropertySources()).contains("camel-file-configuration")) {
            sources.addFirst((PropertySource)new FilePropertySource("camel-file-configuration", applicationContext, config.getFileConfigurations()));
        }
        CamelAutoConfiguration.configureCliConnector(applicationContext, camelContext);
        camelContext.getCamelContextExtension().addContextPlugin(PackageScanClassResolver.class, (Object)new FatJarPackageScanClassResolver());
        camelContext.getCamelContextExtension().addContextPlugin(PackageScanResourceResolver.class, (Object)new FatJarPackageScanResourceResolver());
        if (config.getRouteFilterIncludePattern() != null || config.getRouteFilterExcludePattern() != null) {
            LOG.info("Route filtering pattern: include={}, exclude={}", (Object)config.getRouteFilterIncludePattern(), (Object)config.getRouteFilterExcludePattern());
            ((Model)camelContext.getCamelContextExtension().getContextPlugin(Model.class)).setRouteFilterPattern(config.getRouteFilterIncludePattern(), config.getRouteFilterExcludePattern());
        }
        DefaultConfigurationConfigurer.configure((CamelContext)camelContext, (DefaultConfigurationProperties)config);
        DefaultConfigurationConfigurer.afterConfigure((CamelContext)camelContext);
        DefaultConfigurationConfigurer.afterPropertiesSet((CamelContext)camelContext);
        return camelContext;
    }

    static void configureCliConnector(ApplicationContext applicationContext, CamelContext camelContext) {
        try {
            CliConnectorFactory ccf = (CliConnectorFactory)applicationContext.getBean(CliConnectorFactory.class);
            CliConnector connector = ccf.createConnector();
            camelContext.addService((Object)connector, true);
            ServiceHelper.startService((Service)connector);
        }
        catch (BeansException ccf) {
        }
        catch (Exception e) {
            throw RuntimeCamelException.wrapRuntimeException((Throwable)e);
        }
    }

    static void configureStartupRecorder(CamelContext camelContext, CamelConfigurationProperties config) {
        StartupStepRecorder fr;
        if ("false".equals(config.getStartupRecorder())) {
            camelContext.getCamelContextExtension().getStartupStepRecorder().setEnabled(false);
        } else if ("logging".equals(config.getStartupRecorder())) {
            camelContext.getCamelContextExtension().setStartupStepRecorder((StartupStepRecorder)new LoggingStartupStepRecorder());
        } else if (("java-flight-recorder".equals(config.getStartupRecorder()) || config.getStartupRecorder() == null) && (fr = (StartupStepRecorder)camelContext.getCamelContextExtension().getBootstrapFactoryFinder().newInstance("startup-step-recorder", StartupStepRecorder.class).orElse(null)) != null) {
            LOG.debug("Discovered startup recorder: {} from classpath", (Object)fr);
            fr.setRecording(config.isStartupRecorderRecording());
            fr.setStartupRecorderDuration(config.getStartupRecorderDuration());
            fr.setRecordingProfile(config.getStartupRecorderProfile());
            fr.setMaxDepth(config.getStartupRecorderMaxDepth());
            camelContext.getCamelContextExtension().setStartupStepRecorder(fr);
        }
    }

    @Bean
    CamelSpringBootApplicationController applicationController(ApplicationContext applicationContext, CamelContext camelContext) {
        return new CamelSpringBootApplicationController(applicationContext, camelContext);
    }

    @Bean
    @ConditionalOnMissingBean(value={RoutesCollector.class})
    @ConditionalOnMissingClass(value={"org.apache.camel.spring.boot.endpointdsl.EndpointDslRouteCollector"})
    RoutesCollector routesCollector() {
        return new DefaultRoutesCollector();
    }

    @Bean
    @ConditionalOnMissingBean(value={CamelSpringBootApplicationListener.class})
    CamelSpringBootApplicationListener routesCollectorListener(ApplicationContext applicationContext, CamelConfigurationProperties config, RoutesCollector routesCollector) {
        Collection configurations = applicationContext.getBeansOfType(CamelContextConfiguration.class).values();
        return new CamelSpringBootApplicationListener(applicationContext, new ArrayList<CamelContextConfiguration>(configurations), config, routesCollector);
    }

    @Bean(destroyMethod="")
    @ConditionalOnMissingBean(value={FluentProducerTemplate.class})
    @Lazy
    FluentProducerTemplate fluentProducerTemplate(CamelContext camelContext, CamelConfigurationProperties config) throws Exception {
        FluentProducerTemplate fluentProducerTemplate = camelContext.createFluentProducerTemplate(config.getProducerTemplateCacheSize());
        camelContext.addService((Object)fluentProducerTemplate);
        return fluentProducerTemplate;
    }

    @Bean(destroyMethod="")
    @ConditionalOnMissingBean(value={ProducerTemplate.class})
    @Lazy
    ProducerTemplate producerTemplate(CamelContext camelContext, CamelConfigurationProperties config) throws Exception {
        ProducerTemplate producerTemplate = camelContext.createProducerTemplate(config.getProducerTemplateCacheSize());
        camelContext.addService((Object)producerTemplate);
        return producerTemplate;
    }

    @Bean(destroyMethod="")
    @ConditionalOnMissingBean(value={ConsumerTemplate.class})
    @Lazy
    ConsumerTemplate consumerTemplate(CamelContext camelContext, CamelConfigurationProperties config) throws Exception {
        ConsumerTemplate consumerTemplate = camelContext.createConsumerTemplate(config.getConsumerTemplateCacheSize());
        camelContext.addService((Object)consumerTemplate);
        return consumerTemplate;
    }

    @Bean
    @ConditionalOnMissingBean(value={PropertiesParser.class})
    PropertiesParser propertiesParser(Environment env) {
        return new SpringPropertiesParser(env);
    }

    @Bean(destroyMethod="")
    org.apache.camel.component.properties.PropertiesComponent properties(PropertiesParser parser) {
        org.apache.camel.component.properties.PropertiesComponent pc = new org.apache.camel.component.properties.PropertiesComponent();
        pc.setPropertiesParser(parser);
        return pc;
    }

    @Bean
    CamelBeanPostProcessor camelBeanPostProcessor(ApplicationContext applicationContext) {
        return new CamelSpringBootBeanPostProcessor(applicationContext);
    }
}

