/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.spring.boot.util;

import java.util.Iterator;
import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.PropertyBindingException;
import org.apache.camel.spi.PropertyConfigurer;
import org.apache.camel.support.IntrospectionSupport;
import org.apache.camel.support.PropertyBindingSupport;
import org.apache.camel.support.service.ServiceHelper;
import org.apache.camel.util.ObjectHelper;

public final class CamelPropertiesHelper {
    private CamelPropertiesHelper() {
    }

    public static void copyProperties(CamelContext camelContext, Object source, Object target) {
        ObjectHelper.notNull((Object)camelContext, (String)"camel context");
        ObjectHelper.notNull((Object)source, (String)"source");
        ObjectHelper.notNull((Object)target, (String)"target");
        CamelPropertiesHelper.setCamelProperties(camelContext, target, source instanceof Map ? (Map)source : IntrospectionSupport.getNonNullProperties((Object)source), false);
    }

    public static boolean setCamelProperties(CamelContext context, Object target, Map<String, Object> properties, boolean failIfNotSet) {
        ObjectHelper.notNull((Object)context, (String)"context");
        ObjectHelper.notNull((Object)target, (String)"target");
        ObjectHelper.notNull(properties, (String)"properties");
        boolean rc = false;
        PropertyConfigurer configurer = null;
        if (target instanceof Component) {
            ServiceHelper.initService((Object)target);
            configurer = ((Component)target).getComponentPropertyConfigurer();
        }
        Iterator<Map.Entry<String, Object>> it = properties.entrySet().iterator();
        while (it.hasNext()) {
            boolean hit;
            String stringValue;
            String name;
            block6: {
                Map.Entry<String, Object> entry = it.next();
                name = entry.getKey();
                Object value = entry.getValue();
                stringValue = value != null ? value.toString() : null;
                hit = false;
                try {
                    hit = PropertyBindingSupport.build().withConfigurer(configurer).withIgnoreCase(true).bind(context, target, name, value);
                }
                catch (PropertyBindingException e) {
                    if (stringValue == null) break block6;
                    if (stringValue.startsWith("#")) {
                        stringValue = stringValue.substring(1);
                    }
                    stringValue = "#bean:" + stringValue;
                    hit = PropertyBindingSupport.build().withIgnoreCase(true).bind(context, target, name, (Object)stringValue);
                }
            }
            if (hit) {
                it.remove();
                rc = true;
                continue;
            }
            if (!failIfNotSet) continue;
            throw new IllegalArgumentException("Cannot configure option [" + name + "] with value [" + stringValue + "] as the bean class [" + ObjectHelper.classCanonicalName((Object)target) + "] has no suitable setter method, or not possible to lookup a bean with the id [" + stringValue + "] in Spring Boot registry");
        }
        return rc;
    }
}

