/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.http.springboot;

import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.camel.component.http.springboot.HttpComponentConverter;
import org.apache.hc.core5.util.Timeout;
import org.springframework.boot.context.properties.ConfigurationPropertiesBinding;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.core.convert.converter.GenericConverter;
import org.springframework.stereotype.Component;

@Configuration(proxyBeanMethods=false)
@ConfigurationPropertiesBinding
@Component
public class HttpComponentTimeoutConverter
extends HttpComponentConverter {
    @Override
    public Set<GenericConverter.ConvertiblePair> getConvertibleTypes() {
        LinkedHashSet<GenericConverter.ConvertiblePair> answer = new LinkedHashSet<GenericConverter.ConvertiblePair>();
        answer.add(new GenericConverter.ConvertiblePair(Integer.class, Timeout.class));
        answer.add(new GenericConverter.ConvertiblePair(Long.class, Timeout.class));
        answer.add(new GenericConverter.ConvertiblePair(String.class, Timeout.class));
        return answer;
    }

    @Override
    public Object convert(Object source, TypeDescriptor sourceType, TypeDescriptor targetType) {
        if (source == null) {
            return null;
        }
        if (source instanceof Integer) {
            Integer value = (Integer)source;
            return Timeout.ofMilliseconds((long)value.longValue());
        }
        if (source instanceof Long) {
            Long value = (Long)source;
            return Timeout.ofMilliseconds((long)value);
        }
        if (source instanceof String) {
            String value = (String)source;
            if (value.startsWith("#")) {
                return super.convert(source, sourceType, targetType);
            }
            return Timeout.ofMilliseconds((long)Long.parseLong(value));
        }
        return null;
    }
}

