/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.reactive.streams;

import io.quarkus.runtime.RuntimeValue;
import io.quarkus.runtime.annotations.Recorder;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.reactive.streams.ReactiveStreamsComponent;
import org.apache.camel.component.reactive.streams.api.CamelReactiveStreamsService;
import org.apache.camel.component.reactive.streams.api.CamelReactiveStreamsServiceFactory;
import org.apache.camel.component.reactive.streams.engine.DefaultCamelReactiveStreamsServiceFactory;
import org.apache.camel.component.reactive.streams.engine.ReactiveStreamsEngineConfiguration;
import org.apache.camel.support.service.ServiceHelper;

@Recorder
public class ReactiveStreamsRecorder {
    public RuntimeValue<CamelReactiveStreamsServiceFactory> createDefaultReactiveStreamsServiceFactory() {
        return new RuntimeValue((Object)new DefaultCamelReactiveStreamsServiceFactory());
    }

    public RuntimeValue<ReactiveStreamsComponent> createReactiveStreamsComponent(RuntimeValue<CamelReactiveStreamsServiceFactory> serviceFactory) {
        return new RuntimeValue((Object)new QuarkusReactiveStreamsComponent((CamelReactiveStreamsServiceFactory)serviceFactory.getValue()));
    }

    private static class QuarkusReactiveStreamsComponent
    extends ReactiveStreamsComponent {
        private final CamelReactiveStreamsServiceFactory reactiveStreamServiceFactory;
        private final Object lock;
        private CamelReactiveStreamsService reactiveStreamService;

        public QuarkusReactiveStreamsComponent(CamelReactiveStreamsServiceFactory reactiveStreamServiceFactory) {
            this.reactiveStreamServiceFactory = reactiveStreamServiceFactory;
            this.lock = new Object();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public CamelReactiveStreamsService getReactiveStreamsService() {
            Object object = this.lock;
            synchronized (object) {
                if (this.getReactiveStreamsEngineConfiguration() == null) {
                    ReactiveStreamsEngineConfiguration reactiveStreamsEngineConfiguration = new ReactiveStreamsEngineConfiguration();
                    reactiveStreamsEngineConfiguration.setThreadPoolMaxSize(this.getThreadPoolMaxSize());
                    reactiveStreamsEngineConfiguration.setThreadPoolMinSize(this.getThreadPoolMinSize());
                    reactiveStreamsEngineConfiguration.setThreadPoolName(this.getThreadPoolName());
                    this.setReactiveStreamsEngineConfiguration(reactiveStreamsEngineConfiguration);
                }
                if (this.reactiveStreamService == null) {
                    this.reactiveStreamService = this.reactiveStreamServiceFactory.newInstance(this.getCamelContext(), this.getReactiveStreamsEngineConfiguration());
                    try {
                        this.getCamelContext().addService((Object)this.reactiveStreamService, true, true);
                    }
                    catch (Exception e) {
                        throw new RuntimeCamelException((Throwable)e);
                    }
                }
            }
            return this.reactiveStreamService;
        }

        protected void doStop() throws Exception {
            ServiceHelper.stopService((Object)this.reactiveStreamService);
            this.reactiveStreamService = null;
            super.doStop();
        }
    }
}

