/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.maven;

import java.io.File;
import java.nio.file.Path;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.camel.maven.config.ConnectorConfigGenerator;
import org.apache.camel.tooling.util.FileUtil;
import org.apache.camel.util.ObjectHelper;
import org.apache.kafka.connect.source.SourceConnector;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="generate-connector-config", defaultPhase=LifecyclePhase.GENERATE_SOURCES)
public class GenerateConnectorConfigMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project.build.directory}/generated-sources/connector-configurations")
    private File generatedSrcDir;
    @Parameter(property="camel.debezium.connector.class", required=true)
    private String connectorClassName;
    @Parameter(property="camel.debezium.connector.config.class", required=true)
    private String connectorConfigClassName;
    @Parameter(property="camel.debezium.fields")
    private Map<String, Object> fields = Collections.emptyMap();
    @Parameter(property="camel.debezium.required.fields")
    private List<String> requiredFields = Collections.emptyList();
    @Parameter(property="camel.debezium.package.name")
    private String packageName;

    public void execute() throws MojoFailureException {
        Set<String> requiredFields = this.getRequiredFields();
        Map<String, Object> overrideFields = this.getFields();
        Class configClazz = ObjectHelper.loadClass((String)this.connectorConfigClassName);
        if (configClazz == null) {
            throw new MojoFailureException("connectorConfigClassName not found.");
        }
        try {
            ConnectorConfigGenerator connectorConfigGenerator = ConnectorConfigGenerator.create(this.getConnector(), configClazz, this.packageName, requiredFields, overrideFields);
            File parentPath = new File(this.generatedSrcDir, connectorConfigGenerator.getPackageName().replace(".", "/"));
            File connectorConfigClassFile = new File(parentPath, connectorConfigGenerator.getClassName() + ".java");
            if (!connectorConfigClassFile.exists()) {
                connectorConfigClassFile.getParentFile().mkdirs();
                connectorConfigClassFile.createNewFile();
            }
            FileUtil.updateFile((Path)connectorConfigClassFile.toPath(), (String)connectorConfigGenerator.printClassAsString());
        }
        catch (Exception e) {
            throw new MojoFailureException(e.getMessage(), (Throwable)e);
        }
    }

    private SourceConnector getConnector() {
        return (SourceConnector)org.apache.camel.support.ObjectHelper.newInstance((Class)ObjectHelper.loadClass((String)this.connectorClassName), SourceConnector.class);
    }

    public void setGeneratedSrcDir(File generatedSrcDir) {
        this.generatedSrcDir = generatedSrcDir;
    }

    public void setConnectorClassName(String connectorClassName) {
        this.connectorClassName = connectorClassName;
    }

    public void setConnectorConfigClassName(String connectorConfigClassName) {
        this.connectorConfigClassName = connectorConfigClassName;
    }

    public void setFields(Map<String, Object> fields) {
        this.fields = fields;
    }

    public void setRequiredFields(List<String> requiredFields) {
        this.requiredFields = requiredFields;
    }

    public Set<String> getRequiredFields() {
        return new HashSet<String>(this.requiredFields);
    }

    public Map<String, Object> getFields() {
        return this.fields;
    }
}

