/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.aggregate.zipfile;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import org.apache.camel.AggregationStrategy;
import org.apache.camel.Exchange;
import org.apache.camel.WrappedFile;
import org.apache.camel.component.file.FileConsumer;
import org.apache.camel.component.file.GenericFileOperationFailedException;
import org.apache.camel.spi.Configurer;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.Synchronization;
import org.apache.camel.support.ExchangeHelper;
import org.apache.camel.util.FileUtil;

@Metadata(label="bean", description="AggregationStrategy to zip together incoming messages into a zip file. Please note that this aggregation strategy requires eager completion check to work properly.", annotations={"interfaceName=org.apache.camel.AggregationStrategy"})
@Configurer(metadataOnly=true)
public class ZipAggregationStrategy
implements AggregationStrategy {
    @Metadata(description="Sets the prefix that will be used when creating the ZIP filename.")
    private String filePrefix;
    @Metadata(description="Sets the suffix that will be used when creating the ZIP filename.", defaultValue="zip")
    private String fileSuffix = ".zip";
    @Metadata(label="advanced", description="Whether to add empty files to the ZIP.", defaultValue="false")
    private boolean allowEmptyFiles;
    @Metadata(label="advanced", description="If the incoming message is from a file, then the folder structure of said file can be preserved")
    private boolean preserveFolderStructure;
    @Metadata(label="advanced", description="Whether to use CamelFileName header for the filename instead of using unique message id")
    private boolean useFilenameHeader;
    @Metadata(label="advanced", description="Whether to use temporary files for zip manipulations instead of memory.")
    private boolean useTempFile;
    @Metadata(label="advanced", description="Sets the parent directory to use for writing temporary files")
    private File parentDir = new File(System.getProperty("java.io.tmpdir"));

    public ZipAggregationStrategy() {
        this(false);
    }

    public ZipAggregationStrategy(boolean preserveFolderStructure) {
        this(preserveFolderStructure, false);
    }

    public ZipAggregationStrategy(boolean preserveFolderStructure, boolean useFilenameHeader) {
        this(preserveFolderStructure, useFilenameHeader, false);
    }

    public ZipAggregationStrategy(boolean preserveFolderStructure, boolean useFilenameHeader, boolean useTempFile) {
        this(preserveFolderStructure, useFilenameHeader, useTempFile, false);
    }

    public ZipAggregationStrategy(boolean preserveFolderStructure, boolean useFilenameHeader, boolean useTempFile, boolean allowEmptyFiles) {
        this.preserveFolderStructure = preserveFolderStructure;
        this.useFilenameHeader = useFilenameHeader;
        this.useTempFile = useTempFile;
        this.allowEmptyFiles = allowEmptyFiles;
    }

    public String getFilePrefix() {
        return this.filePrefix;
    }

    public void setFilePrefix(String filePrefix) {
        this.filePrefix = filePrefix;
    }

    public String getFileSuffix() {
        return this.fileSuffix;
    }

    public void setFileSuffix(String fileSuffix) {
        this.fileSuffix = fileSuffix;
    }

    public boolean isAllowEmptyFiles() {
        return this.allowEmptyFiles;
    }

    public void setAllowEmptyFiles(boolean allowEmptyFiles) {
        this.allowEmptyFiles = allowEmptyFiles;
    }

    public File getParentDir() {
        return this.parentDir;
    }

    public void setParentDir(File parentDir) {
        this.parentDir = parentDir;
    }

    public void setParentDir(String parentDir) {
        this.parentDir = new File(parentDir);
    }

    public boolean isPreserveFolderStructure() {
        return this.preserveFolderStructure;
    }

    public void setPreserveFolderStructure(boolean preserveFolderStructure) {
        this.preserveFolderStructure = preserveFolderStructure;
    }

    public boolean isUseTempFile() {
        return this.useTempFile;
    }

    public void setUseTempFile(boolean useTempFile) {
        this.useTempFile = useTempFile;
    }

    public boolean isUseFilenameHeader() {
        return this.useFilenameHeader;
    }

    public void setUseFilenameHeader(boolean useFilenameHeader) {
        this.useFilenameHeader = useFilenameHeader;
    }

    /*
     * Unable to fully structure code
     */
    public Exchange aggregate(Exchange oldExchange, Exchange newExchange) {
        answer = oldExchange;
        if (newExchange == null) {
            return oldExchange;
        }
        if (oldExchange == null) {
            try {
                zipFile = FileUtil.createTempFile((String)this.filePrefix, (String)this.fileSuffix, (File)this.parentDir);
                ZipAggregationStrategy.newZipFile(zipFile);
            }
            catch (IOException | URISyntaxException e) {
                throw new GenericFileOperationFailedException(e.getMessage(), (Throwable)e);
            }
            answer = newExchange;
            answer.getExchangeExtension().addOnCompletion((Synchronization)new DeleteZipFileOnCompletion(zipFile));
        } else {
            zipFile = (File)oldExchange.getIn().getBody(File.class);
        }
        body = newExchange.getIn().getBody();
        if (body instanceof WrappedFile) {
            body = ((WrappedFile)body).getFile();
        }
        charset = ExchangeHelper.getCharsetName((Exchange)newExchange, (boolean)true);
        if (body instanceof File) {
            try {
                appendFile = (File)body;
                if (!this.allowEmptyFiles && appendFile.length() <= 0L) ** GOTO lbl36
                entryName = this.preserveFolderStructure != false ? (String)newExchange.getIn().getHeader("CamelFileName", String.class) : newExchange.getIn().getMessageId();
                this.addFileToZip(zipFile, appendFile, this.preserveFolderStructure != false ? entryName : null);
            }
            catch (Exception e) {
                throw new GenericFileOperationFailedException(e.getMessage(), (Throwable)e);
            }
        } else {
            try {
                buffer = (byte[])newExchange.getIn().getMandatoryBody(byte[].class);
                if (this.allowEmptyFiles || buffer.length > 0) {
                    entryName = this.useFilenameHeader != false ? (String)newExchange.getIn().getHeader("CamelFileName", String.class) : newExchange.getIn().getMessageId();
                    this.addEntryToZip(zipFile, entryName, buffer, charset);
                }
            }
            catch (Exception e) {
                throw new GenericFileOperationFailedException(e.getMessage(), (Throwable)e);
            }
        }
lbl36:
        // 3 sources

        genericFile = FileConsumer.asGenericFile((String)zipFile.getParent(), (File)zipFile, (String)charset, (boolean)false);
        genericFile.bindToExchange(answer);
        return answer;
    }

    public void onCompletion(Exchange exchange, Exchange inputExchange) {
        if (inputExchange != null) {
            exchange.getExchangeExtension().handoverCompletions(inputExchange);
        }
    }

    private static void newZipFile(File zipFile) throws URISyntaxException, IOException {
        if (zipFile.exists() && !zipFile.delete()) {
            throw new IOException("Cannot delete file " + String.valueOf(zipFile));
        }
        HashMap<String, String> env = new HashMap<String, String>();
        env.put("create", Boolean.TRUE.toString());
        FileSystem ignored = FileSystems.newFileSystem(ZipAggregationStrategy.getZipURI(zipFile), env);
        if (ignored != null) {
            ignored.close();
        }
    }

    private void addFileToZip(File zipFile, File file, String fileName) throws IOException, URISyntaxException {
        String entryName = fileName == null ? file.getName() : fileName;
        HashMap<String, Boolean> env = new HashMap<String, Boolean>();
        env.put("useTempFile", this.useTempFile);
        try (FileSystem fs = FileSystems.newFileSystem(ZipAggregationStrategy.getZipURI(zipFile), env);){
            Path dest = fs.getPath("/", entryName);
            Path parent = dest.getParent();
            if (parent != null) {
                Files.createDirectories(parent, new FileAttribute[0]);
                Files.copy(file.toPath(), dest, StandardCopyOption.REPLACE_EXISTING);
            }
        }
    }

    private void addEntryToZip(File zipFile, String entryName, byte[] buffer, String charset) throws IOException, URISyntaxException {
        HashMap<String, Object> env = new HashMap<String, Object>();
        env.put("encoding", charset);
        env.put("useTempFile", this.useTempFile);
        try (FileSystem fs = FileSystems.newFileSystem(ZipAggregationStrategy.getZipURI(zipFile), env);){
            Path dest = fs.getPath("/", entryName);
            Path parent = dest.getParent();
            if (parent != null) {
                Files.createDirectories(parent, new FileAttribute[0]);
                Files.write(dest, buffer, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
            }
        }
    }

    private static URI getZipURI(File zipFile) throws URISyntaxException {
        return new URI("jar", zipFile.toURI().toString(), null);
    }

    private static class DeleteZipFileOnCompletion
    implements Synchronization {
        private final File fileToDelete;

        DeleteZipFileOnCompletion(File fileToDelete) {
            this.fileToDelete = fileToDelete;
        }

        public void onFailure(Exchange exchange) {
        }

        public void onComplete(Exchange exchange) {
            FileUtil.deleteFile((File)this.fileToDelete);
        }
    }
}

