/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dsl.yaml.deserializers;

import java.util.Map;
import org.apache.camel.dsl.yaml.common.YamlDeserializationContext;
import org.apache.camel.dsl.yaml.common.YamlDeserializerBase;
import org.apache.camel.dsl.yaml.common.exception.UnsupportedFieldException;
import org.apache.camel.model.Block;
import org.apache.camel.model.KameletDefinition;
import org.apache.camel.spi.annotations.YamlProperty;
import org.apache.camel.spi.annotations.YamlType;
import org.apache.camel.util.StringHelper;
import org.apache.camel.util.URISupport;
import org.snakeyaml.engine.v2.nodes.MappingNode;
import org.snakeyaml.engine.v2.nodes.Node;
import org.snakeyaml.engine.v2.nodes.NodeTuple;

@YamlType(inline=true, types={KameletDefinition.class}, order=0, nodes={"kamelet"}, properties={@YamlProperty(name="name", type="string", required=true), @YamlProperty(name="parameters", type="object"), @YamlProperty(name="steps", type="array:org.apache.camel.model.ProcessorDefinition")})
public class KameletDeserializer
extends YamlDeserializerBase<KameletDefinition> {
    public KameletDeserializer() {
        super(KameletDefinition.class);
    }

    @Override
    protected KameletDefinition newInstance() {
        return new KameletDefinition();
    }

    @Override
    protected KameletDefinition newInstance(String value) {
        return new KameletDefinition(value);
    }

    @Override
    protected void setProperties(KameletDefinition target, MappingNode node) {
        YamlDeserializationContext dc = KameletDeserializer.getDeserializationContext((Node)node);
        Object name = null;
        Map<String, Object> parameters = null;
        block12: for (NodeTuple tuple : node.getValue()) {
            String key = KameletDeserializer.asText(tuple.getKeyNode());
            Node val = tuple.getValueNode();
            KameletDeserializer.setDeserializationContext(val, dc);
            switch (key = StringHelper.dashToCamelCase((String)key)) {
                case "steps": {
                    KameletDeserializer.setSteps((Block)target, val);
                    continue block12;
                }
                case "id": {
                    target.setId(KameletDeserializer.asText(val));
                    continue block12;
                }
                case "name": {
                    name = KameletDeserializer.asText(val);
                    continue block12;
                }
                case "parameters": {
                    parameters = KameletDeserializer.asScalarMap(tuple.getValueNode());
                    continue block12;
                }
            }
            throw new UnsupportedFieldException((Node)node, key);
        }
        if (parameters != null) {
            name = name + "?" + URISupport.createQueryString(parameters, (boolean)false);
        }
        target.setName(name);
    }
}

