/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dsl.yaml.deserializers;

import java.util.ArrayList;
import java.util.List;
import org.apache.camel.CamelContext;
import org.apache.camel.dsl.yaml.common.YamlDeserializationContext;
import org.apache.camel.dsl.yaml.common.YamlDeserializerSupport;
import org.apache.camel.dsl.yaml.common.exception.YamlDeserializationException;
import org.apache.camel.model.DataFormatDefinition;
import org.apache.camel.model.Model;
import org.apache.camel.model.dataformat.DataFormatsDefinition;
import org.apache.camel.spi.CamelContextCustomizer;
import org.apache.camel.spi.annotations.YamlIn;
import org.apache.camel.spi.annotations.YamlProperty;
import org.apache.camel.spi.annotations.YamlType;
import org.snakeyaml.engine.v2.api.ConstructNode;
import org.snakeyaml.engine.v2.nodes.MappingNode;
import org.snakeyaml.engine.v2.nodes.Node;
import org.snakeyaml.engine.v2.nodes.NodeTuple;
import org.snakeyaml.engine.v2.nodes.SequenceNode;

@YamlIn
@YamlType(nodes={"dataFormats"}, order=0, properties={@YamlProperty(name="__extends", type="array:org.apache.camel.model.dataformat.DataFormatsDefinition")})
public class DataFormatsDefinitionDeserializer
extends YamlDeserializerSupport
implements ConstructNode {
    public Object construct(Node node) {
        DataFormatsCustomizer customizer = new DataFormatsCustomizer();
        YamlDeserializationContext dc = DataFormatsDefinitionDeserializer.getDeserializationContext(node);
        YamlDeserializationContext resolver = (YamlDeserializationContext)((Object)node.getProperty(YamlDeserializationContext.class.getName()));
        if (resolver == null) {
            throw new YamlDeserializationException(node, "Unable to find YamlConstructor");
        }
        SequenceNode sn = DataFormatsDefinitionDeserializer.asSequenceNode(node);
        for (Node item : sn.getValue()) {
            DataFormatsDefinitionDeserializer.setDeserializationContext(item, dc);
            MappingNode mn = DataFormatsDefinitionDeserializer.asMappingNode(item);
            for (NodeTuple nt : mn.getValue()) {
                String name = DataFormatsDefinitionDeserializer.asText(nt.getKeyNode());
                ConstructNode cn = resolver.resolve((Node)mn, name);
                Object answer = cn.construct(nt.getValueNode());
                if (!(answer instanceof DataFormatDefinition)) continue;
                DataFormatDefinition def = (DataFormatDefinition)answer;
                if (dc != null) {
                    def.setResource(dc.getResource());
                }
                customizer.addDataFormat(def);
            }
        }
        return customizer;
    }

    private static class DataFormatsCustomizer
    implements CamelContextCustomizer {
        private final List<DataFormatDefinition> list = new ArrayList<DataFormatDefinition>();

        private DataFormatsCustomizer() {
        }

        void addDataFormat(DataFormatDefinition def) {
            this.list.add(def);
        }

        public void configure(CamelContext camelContext) {
            if (!this.list.isEmpty()) {
                DataFormatsDefinition def = new DataFormatsDefinition();
                def.setDataFormats(this.list);
                Model model = (Model)camelContext.getCamelContextExtension().getContextPlugin(Model.class);
                model.getDataFormats().putAll(def.asMap());
            }
        }
    }
}

