/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.webhook;

import java.net.UnknownHostException;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Base64;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.RestConfiguration;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriParams;
import org.apache.camel.spi.UriPath;
import org.apache.camel.util.HostUtils;
import org.apache.camel.util.ObjectHelper;

@UriParams
public class WebhookConfiguration
implements Cloneable {
    private transient RestConfiguration restConfiguration;
    @UriPath
    @Metadata(required=true)
    private String endpointUri;
    @UriParam
    private String webhookComponentName;
    @UriParam
    private String webhookExternalUrl;
    @UriParam
    private String webhookBasePath;
    @UriParam
    private String webhookPath;
    @UriParam(defaultValue="true")
    private boolean webhookAutoRegister = true;

    public String getWebhookComponentName() {
        return this.webhookComponentName;
    }

    public WebhookConfiguration copy() {
        try {
            return (WebhookConfiguration)this.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeCamelException((Throwable)e);
        }
    }

    public void storeConfiguration(RestConfiguration restConfiguration) {
        this.restConfiguration = restConfiguration;
    }

    public RestConfiguration retrieveRestConfiguration() {
        return this.restConfiguration;
    }

    public String computeFullExternalUrl() throws UnknownHostException {
        String externalServerUrl = this.webhookExternalUrl;
        if (externalServerUrl == null) {
            externalServerUrl = this.computeServerUriPrefix();
        }
        String path = this.computeFullPath(true);
        return externalServerUrl + path;
    }

    public String computeFullPath(boolean external) {
        String contextPath;
        Object path = this.webhookPath;
        if (path == null) {
            path = WebhookConfiguration.computeDefaultPath(this.endpointUri);
        } else if (!((String)path).startsWith("/")) {
            path = "/" + (String)path;
        }
        if (this.webhookBasePath != null) {
            path = !this.webhookBasePath.startsWith("/") ? "/" + this.webhookBasePath + (String)path : this.webhookBasePath + (String)path;
        }
        if (external && (contextPath = this.restConfiguration.getContextPath()) != null) {
            path = !contextPath.startsWith("/") ? "/" + contextPath + (String)path : contextPath + (String)path;
        }
        return path;
    }

    public String computeServerUriPrefix() throws UnknownHostException {
        int num;
        String scheme = "http";
        String host = "";
        int port = 80;
        if (this.restConfiguration.getScheme() != null) {
            scheme = this.restConfiguration.getScheme();
        }
        if (this.restConfiguration.getHost() != null) {
            host = this.restConfiguration.getHost();
        }
        if ((num = this.restConfiguration.getPort()) > 0) {
            port = num;
        }
        if (ObjectHelper.isEmpty((String)host)) {
            if (this.restConfiguration.getHostNameResolver() == RestConfiguration.RestHostNameResolver.allLocalIp) {
                host = "0.0.0.0";
            } else if (this.restConfiguration.getHostNameResolver() == RestConfiguration.RestHostNameResolver.localHostName) {
                host = HostUtils.getLocalHostName();
            } else if (this.restConfiguration.getHostNameResolver() == RestConfiguration.RestHostNameResolver.localIp) {
                host = HostUtils.getLocalIp();
            }
        }
        return scheme + "://" + host + (String)(port != 80 ? ":" + port : "");
    }

    public static String computeDefaultPath(String uri) {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-256");
            md.update(uri.getBytes(StandardCharsets.UTF_8));
            byte[] digest = md.digest();
            return "/" + Base64.getUrlEncoder().encodeToString(digest);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeCamelException("Cannot compute default webhook path", (Throwable)e);
        }
    }

    public String getEndpointUri() {
        return this.endpointUri;
    }

    public void setEndpointUri(String endpointUri) {
        this.endpointUri = endpointUri;
    }

    public void setWebhookComponentName(String webhookComponentName) {
        this.webhookComponentName = webhookComponentName;
    }

    public String getWebhookExternalUrl() {
        return this.webhookExternalUrl;
    }

    public void setWebhookExternalUrl(String webhookExternalUrl) {
        this.webhookExternalUrl = webhookExternalUrl;
    }

    public String getWebhookBasePath() {
        return this.webhookBasePath;
    }

    public void setWebhookBasePath(String webhookBasePath) {
        this.webhookBasePath = webhookBasePath;
    }

    public String getWebhookPath() {
        return this.webhookPath;
    }

    public void setWebhookPath(String webhookPath) {
        this.webhookPath = webhookPath;
    }

    public boolean isWebhookAutoRegister() {
        return this.webhookAutoRegister;
    }

    public void setWebhookAutoRegister(boolean webhookAutoRegister) {
        this.webhookAutoRegister = webhookAutoRegister;
    }
}

