/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.wasm;

import com.dylibso.chicory.runtime.Module;
import java.io.InputStream;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.spi.Resource;
import org.apache.camel.spi.ResourceLoader;
import org.apache.camel.support.DefaultProducer;
import org.apache.camel.support.PluginHelper;
import org.apache.camel.wasm.WasmFunction;
import org.apache.camel.wasm.WasmSupport;

public class WasmProducer
extends DefaultProducer {
    private final String functionModule;
    private final String functionName;
    private Module module;
    private WasmFunction function;

    public WasmProducer(Endpoint endpoint, String functionModule, String functionName) throws Exception {
        super(endpoint);
        this.functionModule = functionModule;
        this.functionName = functionName;
    }

    public void doInit() throws Exception {
        ResourceLoader rl = PluginHelper.getResourceLoader((CamelContext)this.getEndpoint().getCamelContext());
        Resource res = rl.resolveResource(this.functionModule);
        try (InputStream is = res.getInputStream();){
            this.module = Module.builder((InputStream)is).build();
        }
    }

    public void doStart() throws Exception {
        super.doStart();
        if (this.module != null && this.function == null) {
            this.function = new WasmFunction(this.module, this.functionName);
        }
    }

    public void doStop() throws Exception {
        super.doStop();
        this.function = null;
    }

    public void doShutdown() throws Exception {
        super.doShutdown();
        this.function = null;
        this.module = null;
    }

    public void process(Exchange exchange) throws Exception {
        byte[] in = WasmSupport.serialize(exchange);
        byte[] result = this.function.run(in);
        WasmSupport.deserialize(result, exchange);
    }
}

