/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.wal;

import java.util.Arrays;
import java.util.stream.Stream;
import org.apache.camel.component.wal.LogEntry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class TransactionLog {
    private static final Logger LOG = LoggerFactory.getLogger(TransactionLog.class);
    private final int maxCapacity;
    private final EntryContainer[] logEntries;
    private int currentIndex;
    private int currentLayer;

    public TransactionLog(int capacity) {
        this.maxCapacity = capacity;
        this.logEntries = new EntryContainer[capacity];
    }

    public LayerInfo add(LogEntry logEntry) {
        EntryContainer entryContainer;
        boolean rollingOver = false;
        if (this.currentIndex >= this.maxCapacity) {
            ++this.currentLayer;
            this.currentIndex = 0;
            rollingOver = true;
        }
        this.logEntries[this.currentIndex] = entryContainer = new EntryContainer(new LayerInfo(this.currentIndex, this.currentLayer, rollingOver), logEntry);
        ++this.currentIndex;
        return entryContainer.layerInfo;
    }

    static boolean canUpdate(int transactionLogLayer, int transactionLogIndex, int entryInfoLayer, int entryInfoIndex) {
        if (transactionLogLayer == entryInfoLayer && transactionLogIndex >= entryInfoIndex) {
            return true;
        }
        return transactionLogLayer > entryInfoLayer && transactionLogIndex < entryInfoIndex;
    }

    private boolean canUpdate(LayerInfo layerInfo) {
        return TransactionLog.canUpdate(this.currentLayer, this.currentIndex, layerInfo.getLayer(), layerInfo.getIndex());
    }

    public LogEntry update(LayerInfo layerInfo, LogEntry.EntryState state) {
        if (layerInfo == null) {
            if (state != LogEntry.EntryState.PROCESSED) {
                LOG.warn("Discarded an unprocessed record because the layer information is not available: it may have been rolled over");
            }
            return null;
        }
        if (this.canUpdate(layerInfo)) {
            LOG.debug("Updating record with layer: {}", (Object)layerInfo);
            EntryContainer container = this.logEntries[layerInfo.getIndex()];
            container.logEntry.setEntryState(state);
            return container.logEntry;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Discarded a record because it has been rolled-over. Record layer: {}", (Object)layerInfo);
        }
        if (state == LogEntry.EntryState.FAILED) {
            LOG.warn("An update of failed record was discarded because it has been rolled over (it may have taken too long to report back)");
        }
        return null;
    }

    public Stream<EntryContainer> stream() {
        return Arrays.stream(this.logEntries);
    }

    public int currentLayer() {
        return this.currentLayer;
    }

    static class EntryContainer {
        LayerInfo layerInfo;
        LogEntry logEntry;

        public EntryContainer(LayerInfo layerInfo, LogEntry logEntry) {
            this.layerInfo = layerInfo;
            this.logEntry = logEntry;
        }
    }

    public static class LayerInfo {
        private final int index;
        private final int layer;
        private final boolean isRollingOver;

        public LayerInfo(int index, int layer, boolean isRollingOver) {
            this.index = index;
            this.layer = layer;
            this.isRollingOver = isRollingOver;
        }

        public int getIndex() {
            return this.index;
        }

        public int getLayer() {
            return this.layer;
        }

        public boolean isRollingOver() {
            return this.isRollingOver;
        }

        public String toString() {
            return "LayerInfo{index=" + this.index + ", layer=" + this.layer + ", isRollingOver=" + this.isRollingOver + "}";
        }
    }
}

