/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.wal;

class LogEntry {
    private EntryState entryState;
    private int keyMetadata;
    private final byte[] key;
    private int valueMetadata;
    private final byte[] value;

    LogEntry(EntryState entryState, int keyMetadata, byte[] key, int valueMetadata, byte[] value) {
        this.entryState = entryState;
        this.keyMetadata = keyMetadata;
        this.key = key;
        this.valueMetadata = valueMetadata;
        this.value = value;
    }

    public EntryState getEntryState() {
        return this.entryState;
    }

    public int getKeyMetadata() {
        return this.keyMetadata;
    }

    public void setKeyMetadata(int keyMetadata) {
        this.keyMetadata = keyMetadata;
    }

    public int getValueMetadata() {
        return this.valueMetadata;
    }

    public void setValueMetadata(int valueMetadata) {
        this.valueMetadata = valueMetadata;
    }

    public byte[] getKey() {
        return this.key;
    }

    public byte[] getValue() {
        return this.value;
    }

    public void setEntryState(EntryState entryState) {
        this.entryState = entryState;
    }

    public int size() {
        return LogEntry.size(this.key, this.value);
    }

    public static int size(byte[] key, byte[] value) {
        return 12 + key.length + 4 + 4 + value.length;
    }

    public static enum EntryState {
        IGNORED(-1),
        NEW(1),
        PROCESSED(10),
        FAILED(20);

        private final int code;

        private EntryState(int code) {
            this.code = code;
        }

        public int getCode() {
            return this.code;
        }

        public static EntryState fromInt(int value) {
            switch (value) {
                case -1: {
                    return IGNORED;
                }
                case 1: {
                    return NEW;
                }
                case 10: {
                    return PROCESSED;
                }
                case 20: {
                    return FAILED;
                }
            }
            throw new IllegalArgumentException("Invalid state with value " + value);
        }
    }
}

