/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.vertx.websocket;

import io.vertx.core.http.ServerWebSocket;
import java.util.Objects;
import java.util.UUID;

public class VertxWebsocketPeer {
    private final ServerWebSocket webSocket;
    private final String rawPath;
    private final String path;
    private final String connectionKey;

    public VertxWebsocketPeer(ServerWebSocket webSocket, String rawPath) {
        this.webSocket = Objects.requireNonNull(webSocket);
        this.rawPath = Objects.requireNonNull(rawPath);
        this.path = webSocket.path();
        this.connectionKey = UUID.randomUUID().toString();
    }

    public ServerWebSocket getWebSocket() {
        return this.webSocket;
    }

    public String getRawPath() {
        return this.rawPath;
    }

    public String getPath() {
        return this.path;
    }

    public String getConnectionKey() {
        return this.connectionKey;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VertxWebsocketPeer that = (VertxWebsocketPeer)o;
        return Objects.equals(this.connectionKey, that.connectionKey);
    }

    public int hashCode() {
        return Objects.hash(this.connectionKey);
    }
}

