/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.vertx.http;

import io.vertx.core.AsyncResult;
import io.vertx.core.MultiMap;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpMethod;
import io.vertx.ext.web.client.HttpRequest;
import io.vertx.ext.web.client.HttpResponse;
import io.vertx.ext.web.client.WebClient;
import java.io.Closeable;
import java.io.InputStream;
import java.net.URI;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePropertyKey;
import org.apache.camel.Message;
import org.apache.camel.TypeConverter;
import org.apache.camel.component.vertx.http.VertxHttpBinding;
import org.apache.camel.component.vertx.http.VertxHttpConfiguration;
import org.apache.camel.component.vertx.http.VertxHttpEndpoint;
import org.apache.camel.component.vertx.http.VertxHttpHelper;
import org.apache.camel.http.base.HttpHelper;
import org.apache.camel.http.base.HttpOperationFailedException;
import org.apache.camel.spi.HeaderFilterStrategy;
import org.apache.camel.support.ExchangeHelper;
import org.apache.camel.util.IOHelper;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.URISupport;

public class DefaultVertxHttpBinding
implements VertxHttpBinding {
    private volatile Map<String, Object> defaultQueryParams;

    @Override
    public HttpRequest<Buffer> prepareHttpRequest(VertxHttpEndpoint endpoint, Exchange exchange) throws Exception {
        HttpMethod method;
        VertxHttpConfiguration configuration = endpoint.getConfiguration();
        Message message = exchange.getMessage();
        String queryString = VertxHttpHelper.resolveQueryString(exchange);
        Map queryParams = null;
        if (ObjectHelper.isEmpty((String)queryString)) {
            queryString = configuration.getHttpUri().getQuery();
            if (this.defaultQueryParams == null) {
                this.defaultQueryParams = URISupport.parseQuery((String)queryString);
            }
            queryParams = this.defaultQueryParams;
        }
        if ((method = (HttpMethod)message.getHeader("CamelHttpMethod", (Object)configuration.getHttpMethod(), HttpMethod.class)) == null) {
            method = ObjectHelper.isNotEmpty((String)queryString) ? HttpMethod.GET : (message.getBody() != null ? HttpMethod.POST : HttpMethod.GET);
        }
        URI uri = VertxHttpHelper.resolveHttpURI(exchange, endpoint);
        WebClient webClient = endpoint.getWebClient();
        HttpRequest request = uri.getPort() != -1 ? webClient.request(method, uri.getPort(), uri.getHost(), uri.getPath()) : webClient.requestAbs(method, uri.toString());
        if (ObjectHelper.isNotEmpty((String)queryString)) {
            if (queryParams == null) {
                queryParams = URISupport.parseQuery((String)queryString);
            }
            for (Map.Entry<String, Object> entry : queryParams.entrySet()) {
                request.addQueryParam(entry.getKey(), entry.getValue().toString());
            }
        }
        if (ObjectHelper.isNotEmpty((String)configuration.getBasicAuthUsername()) && ObjectHelper.isNotEmpty((String)configuration.getBasicAuthPassword())) {
            request.basicAuthentication(configuration.getBasicAuthUsername(), configuration.getBasicAuthPassword());
        }
        if (ObjectHelper.isNotEmpty((String)configuration.getBearerToken())) {
            request.bearerTokenAuthentication(configuration.getBearerToken());
        }
        this.populateRequestHeaders(exchange, (HttpRequest<Buffer>)request, configuration.getHeaderFilterStrategy());
        if (configuration.getTimeout() > -1L) {
            request.timeout(configuration.getTimeout());
        }
        return request;
    }

    @Override
    public void populateRequestHeaders(Exchange exchange, HttpRequest<Buffer> request, HeaderFilterStrategy strategy) {
        MultiMap headers = request.headers();
        String contentType = ExchangeHelper.getContentType((Exchange)exchange);
        if (ObjectHelper.isNotEmpty((String)contentType)) {
            headers.set("Content-Type", contentType);
        }
        if (strategy != null) {
            TypeConverter tc = exchange.getContext().getTypeConverter();
            for (Map.Entry entry : exchange.getMessage().getHeaders().entrySet()) {
                Object headerValue;
                String key = (String)entry.getKey();
                if (strategy.applyFilterToCamelHeaders(key, headerValue = entry.getValue(), exchange)) continue;
                String str = (String)tc.convertTo(String.class, headerValue);
                headers.set(key, str);
            }
        }
    }

    @Override
    public void handleResponse(VertxHttpEndpoint endpoint, Exchange exchange, AsyncResult<HttpResponse<Buffer>> response) throws Exception {
        Message message = exchange.getMessage();
        HttpResponse result = (HttpResponse)response.result();
        if (response.succeeded()) {
            VertxHttpConfiguration configuration = endpoint.getConfiguration();
            boolean ok = endpoint.isStatusCodeOk(result.statusCode());
            if (!configuration.isThrowExceptionOnFailure() || configuration.isThrowExceptionOnFailure() && ok) {
                this.populateResponseHeaders(exchange, (HttpResponse<Buffer>)result, configuration.getHeaderFilterStrategy());
                message.setBody(this.processResponseBody(endpoint, exchange, (HttpResponse<Buffer>)result));
            } else {
                exchange.setException(this.handleResponseFailure(endpoint, exchange, (HttpResponse<Buffer>)result));
            }
        } else {
            exchange.setException(response.cause());
        }
    }

    @Override
    public void populateResponseHeaders(final Exchange exchange, HttpResponse<Buffer> response, final HeaderFilterStrategy strategy) {
        final Message message = exchange.getMessage();
        message.setHeader("CamelHttpResponseCode", (Object)response.statusCode());
        message.setHeader("CamelHttpResponseText", (Object)response.statusMessage());
        MultiMap headers = response.headers();
        if (headers != null && !headers.isEmpty()) {
            HashMap<String, Object> copy = new HashMap<String, Object>(exchange.getMessage().getHeaders());
            exchange.getMessage().getHeaders().clear();
            headers.forEach((Consumer)new Consumer<Map.Entry<String, String>>(){
                boolean found;

                @Override
                public void accept(Map.Entry<String, String> entry) {
                    String name = entry.getKey();
                    String value = entry.getValue();
                    if (!this.found && name.equalsIgnoreCase("content-type")) {
                        this.found = true;
                        name = "Content-Type";
                        exchange.setProperty(ExchangePropertyKey.CHARSET_NAME, (Object)IOHelper.getCharsetNameFromContentType((String)value));
                    }
                    Object extracted = HttpHelper.extractHttpParameterValue((String)value);
                    if (strategy != null && !strategy.applyFilterToExternalHeaders(name, extracted, exchange)) {
                        HttpHelper.appendHeader((Map)message.getHeaders(), (String)name, (Object)extracted);
                    }
                }
            });
            copy.forEach((k, v) -> exchange.getMessage().getHeaders().putIfAbsent(k, v));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object processResponseBody(VertxHttpEndpoint endpoint, Exchange exchange, HttpResponse<Buffer> result, boolean exceptionOnly) throws Exception {
        Buffer responseBody = (Buffer)result.body();
        if (responseBody != null) {
            String contentType = result.getHeader("Content-Type");
            if ("application/x-java-serialized-object".equals(contentType)) {
                InputStream inputStream;
                boolean transferException = endpoint.getConfiguration().isTransferException();
                boolean allowJavaSerializedObject = endpoint.getComponent().isAllowJavaSerializedObject();
                if ((allowJavaSerializedObject || exceptionOnly && transferException) && (inputStream = (InputStream)exchange.getContext().getTypeConverter().convertTo(InputStream.class, (Object)responseBody.getBytes())) != null) {
                    try {
                        Object object = VertxHttpHelper.deserializeJavaObjectFromStream(inputStream);
                        return object;
                    }
                    finally {
                        IOHelper.close((Closeable)inputStream);
                    }
                }
            } else {
                if (endpoint.getConfiguration().isResponsePayloadAsByteArray()) {
                    return responseBody.getBytes();
                }
                return responseBody;
            }
        }
        return null;
    }

    public Object processResponseBody(VertxHttpEndpoint endpoint, Exchange exchange, HttpResponse<Buffer> result) throws Exception {
        return this.processResponseBody(endpoint, exchange, result, false);
    }

    @Override
    public Throwable handleResponseFailure(VertxHttpEndpoint endpoint, Exchange exchange, HttpResponse<Buffer> result) throws Exception {
        Throwable exception;
        Object responseBody = this.processResponseBody(endpoint, exchange, result, true);
        if (responseBody instanceof Throwable) {
            exception = (Throwable)responseBody;
        } else {
            String location = null;
            List redirects = result.followedRedirects();
            if (!redirects.isEmpty()) {
                location = (String)redirects.get(redirects.size() - 1);
            }
            HashMap headers = new HashMap();
            result.headers().names().forEach(header -> headers.put(header, result.getHeader(header)));
            URI httpURI = VertxHttpHelper.resolveHttpURI(exchange, endpoint);
            exception = new HttpOperationFailedException(httpURI.toString(), result.statusCode(), result.statusMessage(), location, headers, result.bodyAsString());
        }
        return exception;
    }
}

