/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.telegram.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.camel.component.telegram.model.InlineKeyboardMarkup;
import org.apache.camel.component.telegram.model.InlineQueryResult;
import org.apache.camel.component.telegram.model.InputMessageContent;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class InlineQueryResultDocument
extends InlineQueryResult {
    private static final String TYPE = "document";
    @JsonProperty(value="document_url")
    private String documentUrl;
    @JsonProperty(value="mime_type")
    private String mimeType;
    @JsonProperty(value="thumb_width")
    private Integer thumbWidth;
    @JsonProperty(value="thumb_height")
    private Integer thumbHeight;
    @JsonProperty(value="thumb_url")
    private String thumbUrl;
    private String title;
    private String caption;
    private String description;
    @JsonProperty(value="parse_mode")
    private String parseMode;
    @JsonProperty(value="input_message_content")
    private InputMessageContent inputMessageContext;

    public InlineQueryResultDocument() {
        super(TYPE);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getDocumentUrl() {
        return this.documentUrl;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public Integer getThumbWidth() {
        return this.thumbWidth;
    }

    public Integer getThumbHeight() {
        return this.thumbHeight;
    }

    public String getThumbUrl() {
        return this.thumbUrl;
    }

    public String getTitle() {
        return this.title;
    }

    public String getCaption() {
        return this.caption;
    }

    public String getDescription() {
        return this.description;
    }

    public String getParseMode() {
        return this.parseMode;
    }

    public InputMessageContent getInputMessageContext() {
        return this.inputMessageContext;
    }

    public void setDocumentUrl(String documentUrl) {
        this.documentUrl = documentUrl;
    }

    public void setMimeType(String mimeType) {
        this.mimeType = mimeType;
    }

    public void setThumbWidth(Integer thumbWidth) {
        this.thumbWidth = thumbWidth;
    }

    public void setThumbHeight(Integer thumbHeight) {
        this.thumbHeight = thumbHeight;
    }

    public void setThumbUrl(String thumbUrl) {
        this.thumbUrl = thumbUrl;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setCaption(String caption) {
        this.caption = caption;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setParseMode(String parseMode) {
        this.parseMode = parseMode;
    }

    public void setInputMessageContext(InputMessageContent inputMessageContext) {
        this.inputMessageContext = inputMessageContext;
    }

    public static final class Builder {
        private String id;
        private InlineKeyboardMarkup replyMarkup;
        private String documentUrl;
        private String mimeType;
        private Integer thumbWidth;
        private Integer thumbHeight;
        private String thumbUrl;
        private String title;
        private String caption;
        private String description;
        private String parseMode;
        private InputMessageContent inputMessageContext;

        private Builder() {
        }

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder replyMarkup(InlineKeyboardMarkup replyMarkup) {
            this.replyMarkup = replyMarkup;
            return this;
        }

        public Builder documentUrl(String url) {
            this.documentUrl = url;
            return this;
        }

        public Builder mimeType(String mimeType) {
            this.mimeType = mimeType;
            return this;
        }

        public Builder width(Integer width) {
            this.thumbWidth = width;
            return this;
        }

        public Builder height(Integer height) {
            this.thumbHeight = height;
            return this;
        }

        public Builder thumbUrl(String thumbUrl) {
            this.thumbUrl = thumbUrl;
            return this;
        }

        public Builder title(String title) {
            this.title = title;
            return this;
        }

        public Builder caption(String caption) {
            this.caption = caption;
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Builder parseMode(String parseMode) {
            this.parseMode = parseMode;
            return this;
        }

        public Builder inputMessageContext(InputMessageContent inputMessageContext) {
            this.inputMessageContext = inputMessageContext;
            return this;
        }

        public InlineQueryResultDocument build() {
            InlineQueryResultDocument inlineQueryResultDocument = new InlineQueryResultDocument();
            inlineQueryResultDocument.setType(InlineQueryResultDocument.TYPE);
            inlineQueryResultDocument.setId(this.id);
            inlineQueryResultDocument.setReplyMarkup(this.replyMarkup);
            inlineQueryResultDocument.mimeType = this.mimeType;
            inlineQueryResultDocument.caption = this.caption;
            inlineQueryResultDocument.inputMessageContext = this.inputMessageContext;
            inlineQueryResultDocument.parseMode = this.parseMode;
            inlineQueryResultDocument.thumbUrl = this.thumbUrl;
            inlineQueryResultDocument.thumbWidth = this.thumbWidth;
            inlineQueryResultDocument.title = this.title;
            inlineQueryResultDocument.thumbHeight = this.thumbHeight;
            inlineQueryResultDocument.documentUrl = this.documentUrl;
            inlineQueryResultDocument.description = this.description;
            return inlineQueryResultDocument;
        }
    }
}

