/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.tahu.handlers;

import java.time.Duration;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.camel.component.tahu.handlers.TahuEdgeClientCallback;
import org.apache.camel.component.tahu.handlers.TahuEdgeMetricHandler;
import org.eclipse.tahu.edge.EdgeClient;
import org.eclipse.tahu.edge.api.MetricHandler;
import org.eclipse.tahu.message.BdSeqManager;
import org.eclipse.tahu.message.model.DeviceDescriptor;
import org.eclipse.tahu.message.model.EdgeNodeDescriptor;
import org.eclipse.tahu.message.model.SparkplugBPayload;
import org.eclipse.tahu.message.model.SparkplugBPayloadMap;
import org.eclipse.tahu.message.model.SparkplugDescriptor;
import org.eclipse.tahu.model.MqttServerDefinition;
import org.eclipse.tahu.mqtt.ClientCallback;
import org.eclipse.tahu.mqtt.RandomStartupDelay;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;

public final class TahuEdgeClient
extends EdgeClient {
    private static final Logger LOG = LoggerFactory.getLogger(TahuEdgeClient.class);
    private static final Duration SHUTDOWN_TIMEOUT = Duration.ofSeconds(5L);
    private final EdgeNodeDescriptor edgeNodeDescriptor;
    private final TahuEdgeMetricHandler tahuEdgeNodeMetricHandler;
    private final TahuEdgeClientCallback tahuEdgeNodeClientCallback;
    private final ExecutorService clientExecutorService;
    private volatile Future<?> clientSubmittedFuture = null;
    private volatile boolean suspended = false;
    private final Marker loggingMarker;

    private TahuEdgeClient(TahuEdgeMetricHandler tahuEdgeNodeMetricHandler, EdgeNodeDescriptor edgeNodeDescriptor, List<String> deviceIds, String primaryHostId, boolean useAliases, Long rebirthDebounceDelay, List<MqttServerDefinition> mqttServerDefinitions, TahuEdgeClientCallback tahuEdgeNodeClientCallback, RandomStartupDelay randomStartupDelay, ExecutorService clientExecutorService) {
        super((MetricHandler)tahuEdgeNodeMetricHandler, edgeNodeDescriptor, deviceIds, primaryHostId, useAliases, rebirthDebounceDelay, mqttServerDefinitions, (ClientCallback)tahuEdgeNodeClientCallback, randomStartupDelay);
        this.edgeNodeDescriptor = edgeNodeDescriptor;
        this.loggingMarker = MarkerFactory.getMarker((String)edgeNodeDescriptor.getDescriptorString());
        this.tahuEdgeNodeMetricHandler = tahuEdgeNodeMetricHandler;
        this.tahuEdgeNodeClientCallback = tahuEdgeNodeClientCallback;
        this.clientExecutorService = clientExecutorService;
    }

    public Future<?> startup() {
        if (this.clientSubmittedFuture == null) {
            this.clientSubmittedFuture = this.clientExecutorService.submit((Runnable)((Object)this));
            this.suspended = false;
        }
        return this.clientSubmittedFuture;
    }

    public void suspend() {
        if (this.clientSubmittedFuture != null && !this.suspended) {
            this.disconnect(false);
            this.suspended = true;
        }
    }

    public void resume() {
        if (this.clientSubmittedFuture != null && this.suspended) {
            this.handleRebirthRequest(false);
            this.suspended = false;
        }
    }

    public void shutdown() {
        Future<?> clientSubmittedFuture = this.clientSubmittedFuture;
        if (clientSubmittedFuture != null) {
            this.suspended = false;
            super.shutdown();
            try {
                clientSubmittedFuture.get(SHUTDOWN_TIMEOUT.toMillis(), TimeUnit.MILLISECONDS);
            }
            catch (TimeoutException te) {
                clientSubmittedFuture.cancel(true);
            }
            catch (InterruptedException | CancellationException | ExecutionException e) {
                LOG.warn(this.loggingMarker, "Caught exception waiting for client shutdown", (Throwable)e);
            }
            this.clientSubmittedFuture = null;
        }
    }

    public SparkplugBPayloadMap addDeviceMetricDataPayloadMap(SparkplugDescriptor metricDescriptor, SparkplugBPayloadMap metricDataTypePayloadMap) {
        return this.tahuEdgeNodeMetricHandler.addDeviceMetricDataPayloadMap(metricDescriptor, metricDataTypePayloadMap);
    }

    public void publishData(SparkplugDescriptor sd, SparkplugBPayload payload) {
        this.tahuEdgeNodeMetricHandler.updateCachedMetrics(sd, payload);
        if (sd.isDeviceDescriptor()) {
            this.publishDeviceData(((DeviceDescriptor)sd).getDeviceId(), payload);
        } else {
            this.publishNodeData(payload);
        }
    }

    public static final class ClientBuilder {
        private EdgeNodeDescriptor edgeNodeDescriptor;
        private List<String> deviceIds;
        private String primaryHostId;
        private boolean useAliases;
        private Long rebirthDebounceDelay = null;
        private List<MqttServerDefinition> serverDefinitions;
        private RandomStartupDelay randomStartupDelay = null;
        private BdSeqManager bdSeqManager;
        private ExecutorService clientExecutorService;
        private volatile TahuEdgeClient tahuEdgeClient;

        public ClientBuilder edgeNodeDescriptor(EdgeNodeDescriptor end) {
            this.checkBuildState();
            this.edgeNodeDescriptor = end;
            return this;
        }

        public ClientBuilder deviceIds(List<String> deviceIds) {
            this.checkBuildState();
            this.deviceIds = List.copyOf(deviceIds);
            return this;
        }

        public ClientBuilder primaryHostId(String primaryHostId) {
            this.checkBuildState();
            this.primaryHostId = primaryHostId;
            return this;
        }

        public ClientBuilder useAliases(boolean useAliases) {
            this.checkBuildState();
            this.useAliases = useAliases;
            return this;
        }

        public ClientBuilder rebirthDebounceDelay(Long rebirthDebounceDelay) {
            this.checkBuildState();
            this.rebirthDebounceDelay = rebirthDebounceDelay;
            return this;
        }

        public ClientBuilder serverDefinitions(List<MqttServerDefinition> serverDefinitions) {
            this.checkBuildState();
            this.serverDefinitions = List.copyOf(serverDefinitions);
            return this;
        }

        public ClientBuilder bdSeqManager(BdSeqManager bsm) {
            this.checkBuildState();
            this.bdSeqManager = bsm;
            return this;
        }

        public ClientBuilder clientExecutorService(ExecutorService clientExecutorService) {
            this.checkBuildState();
            this.clientExecutorService = clientExecutorService;
            return this;
        }

        private void checkBuildState() throws IllegalStateException {
            if (this.tahuEdgeClient != null) {
                throw new IllegalStateException("Unable to reuse a ClientBuilder for multiple TahuEdgeClient instances");
            }
        }

        public TahuEdgeClient build() {
            TahuEdgeClient cachedTahuEdgeClient = this.tahuEdgeClient;
            if (cachedTahuEdgeClient == null) {
                TahuEdgeMetricHandler tahuEdgeNodeMetricHandler = new TahuEdgeMetricHandler(this.edgeNodeDescriptor, this.bdSeqManager);
                TahuEdgeClientCallback tahuClientCallback = new TahuEdgeClientCallback(this.edgeNodeDescriptor, tahuEdgeNodeMetricHandler);
                cachedTahuEdgeClient = this.tahuEdgeClient = new TahuEdgeClient(tahuEdgeNodeMetricHandler, this.edgeNodeDescriptor, this.deviceIds, this.primaryHostId, this.useAliases, this.rebirthDebounceDelay, this.serverDefinitions, tahuClientCallback, this.randomStartupDelay, this.clientExecutorService);
                LOG.debug(this.tahuEdgeClient.loggingMarker, "Created TahuEdgeClient for {} with deviceIds {}", (Object)this.edgeNodeDescriptor, this.deviceIds);
                tahuEdgeNodeMetricHandler.setClient(cachedTahuEdgeClient);
                tahuClientCallback.setClient(cachedTahuEdgeClient);
            }
            return cachedTahuEdgeClient;
        }
    }
}

