/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.amqp.rabbit.listener.adapter;

import com.rabbitmq.client.Channel;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.springframework.amqp.AmqpIOException;
import org.springframework.amqp.AmqpIllegalStateException;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.core.MessageListener;
import org.springframework.amqp.core.MessageProperties;
import org.springframework.amqp.rabbit.listener.adapter.AbstractAdaptableMessageListener;
import org.springframework.amqp.rabbit.listener.adapter.InvocationResult;
import org.springframework.amqp.rabbit.listener.api.ChannelAwareMessageListener;
import org.springframework.amqp.rabbit.support.ListenerExecutionFailedException;
import org.springframework.amqp.support.converter.MessageConverter;
import org.springframework.util.Assert;
import org.springframework.util.MethodInvoker;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public class MessageListenerAdapter
extends AbstractAdaptableMessageListener {
    private final Map<String, String> queueOrTagToMethodName = new HashMap<String, String>();
    public static final String ORIGINAL_DEFAULT_LISTENER_METHOD = "handleMessage";
    private Object delegate;
    private String defaultListenerMethod = "handleMessage";

    public MessageListenerAdapter() {
        this.delegate = this;
    }

    public MessageListenerAdapter(Object delegate) {
        this.doSetDelegate(delegate);
    }

    public MessageListenerAdapter(Object delegate, MessageConverter messageConverter) {
        this.doSetDelegate(delegate);
        super.setMessageConverter(messageConverter);
    }

    public MessageListenerAdapter(Object delegate, String defaultListenerMethod) {
        this(delegate);
        this.defaultListenerMethod = defaultListenerMethod;
    }

    public void setDelegate(Object delegate) {
        this.doSetDelegate(delegate);
    }

    private void doSetDelegate(Object delegate) {
        Assert.notNull((Object)delegate, (String)"Delegate must not be null");
        this.delegate = delegate;
    }

    protected Object getDelegate() {
        return this.delegate;
    }

    public void setDefaultListenerMethod(String defaultListenerMethod) {
        this.defaultListenerMethod = defaultListenerMethod;
    }

    protected String getDefaultListenerMethod() {
        return this.defaultListenerMethod;
    }

    public void setQueueOrTagToMethodName(Map<String, String> queueOrTagToMethodName) {
        this.queueOrTagToMethodName.putAll(queueOrTagToMethodName);
    }

    public void addQueueOrTagToMethodName(String queueOrTag, String methodName) {
        this.queueOrTagToMethodName.put(queueOrTag, methodName);
    }

    public String removeQueueOrTagToMethodName(String queueOrTag) {
        return this.queueOrTagToMethodName.remove(queueOrTag);
    }

    @Override
    public void onMessage(Message message, Channel channel) throws Exception {
        Object convertedMessage;
        String methodName;
        Object delegateListener = this.getDelegate();
        if (!delegateListener.equals(this)) {
            if (delegateListener instanceof ChannelAwareMessageListener) {
                ChannelAwareMessageListener chaml = (ChannelAwareMessageListener)delegateListener;
                chaml.onMessage(message, channel);
                return;
            }
            if (delegateListener instanceof MessageListener) {
                MessageListener messageListener = (MessageListener)delegateListener;
                messageListener.onMessage(message);
                return;
            }
        }
        if ((methodName = this.getListenerMethodName(message, convertedMessage = this.extractMessage(message))) == null) {
            throw new AmqpIllegalStateException("No default listener method specified: Either specify a non-null value for the 'defaultListenerMethod' property or override the 'getListenerMethodName' method.");
        }
        Object[] listenerArguments = this.buildListenerArguments(convertedMessage, channel, message);
        Object result = this.invokeListenerMethod(methodName, listenerArguments, message);
        if (result != null) {
            this.handleResult(new InvocationResult(result, null, null, null, null), message, channel);
        } else {
            this.logger.trace((Object)"No result object given - no result to handle");
        }
    }

    protected String getListenerMethodName(Message originalMessage, Object extractedMessage) {
        if (this.queueOrTagToMethodName.size() > 0) {
            MessageProperties props = originalMessage.getMessageProperties();
            String methodName = this.queueOrTagToMethodName.get(props.getConsumerQueue());
            if (methodName == null) {
                methodName = this.queueOrTagToMethodName.get(props.getConsumerTag());
            }
            if (methodName != null) {
                return methodName;
            }
        }
        return this.getDefaultListenerMethod();
    }

    protected Object[] buildListenerArguments(Object extractedMessage, Channel channel, Message message) {
        return new Object[]{extractedMessage};
    }

    protected Object invokeListenerMethod(String methodName, Object[] arguments, Message originalMessage) {
        try {
            MethodInvoker methodInvoker = new MethodInvoker();
            methodInvoker.setTargetObject(this.getDelegate());
            methodInvoker.setTargetMethod(methodName);
            methodInvoker.setArguments(arguments);
            methodInvoker.prepare();
            return methodInvoker.invoke();
        }
        catch (InvocationTargetException ex) {
            Throwable targetEx = ex.getTargetException();
            if (targetEx instanceof IOException) {
                IOException iox = (IOException)targetEx;
                throw new AmqpIOException(iox);
            }
            throw new ListenerExecutionFailedException("Listener method '" + methodName + "' threw exception", targetEx, originalMessage);
        }
        catch (Exception ex) {
            ArrayList<String> arrayClass = new ArrayList<String>();
            if (arguments != null) {
                for (Object argument : arguments) {
                    arrayClass.add(argument.getClass().toString());
                }
            }
            throw new ListenerExecutionFailedException("Failed to invoke target method '" + methodName + "' with argument type = [" + StringUtils.collectionToCommaDelimitedString(arrayClass) + "], value = [" + ObjectUtils.nullSafeToString((Object[])arguments) + "]", (Throwable)ex, originalMessage);
        }
    }
}

