/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.solr.converter;

import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.DeferredContextBinding;
import org.apache.camel.TypeConverter;
import org.apache.camel.TypeConverterLoaderException;
import org.apache.camel.component.solr.converter.SolrResponseConverter;
import org.apache.camel.spi.TypeConverterLoader;
import org.apache.camel.spi.TypeConverterRegistry;
import org.apache.camel.support.SimpleTypeConverter;
import org.apache.solr.client.solrj.SolrResponse;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.client.solrj.response.SolrPingResponse;

@DeferredContextBinding
public final class SolrResponseConverterLoader
implements TypeConverterLoader,
CamelContextAware {
    private CamelContext camelContext;

    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    public void load(TypeConverterRegistry registry) throws TypeConverterLoaderException {
        this.registerConverters(registry);
    }

    private void registerConverters(TypeConverterRegistry registry) {
        SolrResponseConverterLoader.addTypeConverter(registry, Map.class, Object.class, false, (type, exchange, value) -> SolrResponseConverter.createSolrResponseMap(value, exchange));
        SolrResponseConverterLoader.addTypeConverter(registry, SolrResponse.class, Object.class, false, (type, exchange, value) -> SolrResponseConverter.createSolrResponse(value, exchange));
        SolrResponseConverterLoader.addTypeConverter(registry, QueryResponse.class, Object.class, false, (type, exchange, value) -> SolrResponseConverter.createQueryResponse(value, exchange));
        SolrResponseConverterLoader.addTypeConverter(registry, SolrPingResponse.class, Object.class, false, (type, exchange, value) -> SolrResponseConverter.createSolrPingResponse(value, exchange));
    }

    private static void addTypeConverter(TypeConverterRegistry registry, Class<?> toType, Class<?> fromType, boolean allowNull, SimpleTypeConverter.ConversionMethod method) {
        registry.addTypeConverter(toType, fromType, (TypeConverter)new SimpleTypeConverter(allowNull, method));
    }
}

