/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.solr.converter;

import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import org.apache.camel.Converter;
import org.apache.camel.Exchange;
import org.apache.camel.component.solr.SolrUtils;
import org.apache.solr.client.solrj.SolrResponse;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.client.solrj.response.SolrPingResponse;
import org.apache.solr.client.solrj.response.SolrResponseBase;
import org.apache.solr.common.util.NamedList;

@Converter(generateLoader=true)
public final class SolrResponseConverter {
    private SolrResponseConverter() {
    }

    @Converter
    public static Map<String, Object> createSolrResponseMap(Object body, Exchange exchange) {
        return SolrUtils.parseAsFlatMap(SolrUtils.parseAsMap(SolrResponseConverter.createSolrResponse(body, exchange)));
    }

    @Converter
    public static SolrResponse createSolrResponse(Object body, Exchange exchange) {
        return SolrResponseConverter.createSolrResponse(body, SolrResponseBase.class);
    }

    @Converter
    public static SolrPingResponse createSolrPingResponse(Object body, Exchange exchange) {
        return SolrResponseConverter.createSolrResponse(body, SolrPingResponse.class);
    }

    @Converter
    public static QueryResponse createQueryResponse(Object body, Exchange exchange) {
        return SolrResponseConverter.createSolrResponse(body, QueryResponse.class);
    }

    private static <T extends SolrResponse> T createSolrResponse(Object body, Class<T> type) {
        if (body instanceof NamedList) {
            SolrResponse t;
            NamedList namedList = (NamedList)body;
            try {
                t = (SolrResponse)type.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
            t.setResponse(namedList);
            return (T)t;
        }
        return null;
    }
}

