/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.smb.strategy;

import com.hierynomus.msfscc.fileinformation.FileIdBothDirectoryInformation;
import java.time.Duration;
import org.apache.camel.Exchange;
import org.apache.camel.LoggingLevel;
import org.apache.camel.component.file.GenericFile;
import org.apache.camel.component.file.GenericFileEndpoint;
import org.apache.camel.component.file.GenericFileExclusiveReadLockStrategy;
import org.apache.camel.component.file.GenericFileOperations;
import org.apache.camel.component.smb.strategy.SmbExclusiveReadLockCheck;
import org.apache.camel.spi.CamelLogger;
import org.apache.camel.support.task.ForegroundTask;
import org.apache.camel.support.task.Tasks;
import org.apache.camel.support.task.budget.Budgets;
import org.apache.camel.support.task.budget.IterationBudget;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SmbChangedExclusiveReadLockStrategy
implements GenericFileExclusiveReadLockStrategy<FileIdBothDirectoryInformation> {
    private static final Logger LOG = LoggerFactory.getLogger(SmbChangedExclusiveReadLockStrategy.class);
    private long timeout;
    private long checkInterval = 5000L;
    private LoggingLevel readLockLoggingLevel = LoggingLevel.WARN;
    private long minLength = 1L;
    private long minAge;

    public void prepareOnStartup(GenericFileOperations<FileIdBothDirectoryInformation> tGenericFileOperations, GenericFileEndpoint<FileIdBothDirectoryInformation> tGenericFileEndpoint) {
    }

    public boolean acquireExclusiveReadLock(GenericFileOperations<FileIdBothDirectoryInformation> operations, GenericFile<FileIdBothDirectoryInformation> file, Exchange exchange) {
        LOG.trace("Waiting for exclusive read lock to file: {}", file);
        ForegroundTask task = Tasks.foregroundTask().withBudget((IterationBudget)Budgets.iterationTimeBudget().withMaxDuration(Duration.ofMillis(this.timeout)).withInterval(Duration.ofMillis(this.checkInterval)).build()).withName("smb-acquire-exclusive-read-lock").build();
        SmbExclusiveReadLockCheck exclusiveReadLockCheck = new SmbExclusiveReadLockCheck(this.minAge, this.minLength);
        if (!task.run(() -> exclusiveReadLockCheck.tryAcquireExclusiveReadLock(operations, file))) {
            CamelLogger.log((Logger)LOG, (LoggingLevel)this.readLockLoggingLevel, (String)("Cannot acquire read lock within " + this.timeout + " millis. Will skip the file: " + String.valueOf(file)));
            return false;
        }
        return true;
    }

    public void releaseExclusiveReadLockOnAbort(GenericFileOperations<FileIdBothDirectoryInformation> operations, GenericFile<FileIdBothDirectoryInformation> file, Exchange exchange) {
    }

    public void releaseExclusiveReadLockOnRollback(GenericFileOperations<FileIdBothDirectoryInformation> operations, GenericFile<FileIdBothDirectoryInformation> file, Exchange exchange) {
    }

    public void releaseExclusiveReadLockOnCommit(GenericFileOperations<FileIdBothDirectoryInformation> operations, GenericFile<FileIdBothDirectoryInformation> file, Exchange exchange) {
    }

    public long getTimeout() {
        return this.timeout;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    public long getCheckInterval() {
        return this.checkInterval;
    }

    public void setCheckInterval(long checkInterval) {
        this.checkInterval = checkInterval;
    }

    public void setReadLockLoggingLevel(LoggingLevel readLockLoggingLevel) {
        this.readLockLoggingLevel = readLockLoggingLevel;
    }

    public void setMarkerFiler(boolean markerFiler) {
    }

    public void setDeleteOrphanLockFiles(boolean deleteOrphanLockFiles) {
    }

    public long getMinLength() {
        return this.minLength;
    }

    public void setMinLength(long minLength) {
        this.minLength = minLength;
    }

    public long getMinAge() {
        return this.minAge;
    }

    public void setMinAge(long minAge) {
        this.minAge = minAge;
    }
}

