/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.smb;

import com.hierynomus.msfscc.fileinformation.FileIdBothDirectoryInformation;
import org.apache.camel.Exchange;
import org.apache.camel.component.file.GenericFile;
import org.apache.camel.component.file.GenericFileMessage;
import org.apache.camel.component.smb.SmbOperations;

public class SmbFile
extends GenericFile<FileIdBothDirectoryInformation> {
    private final SmbOperations operations;
    private final boolean download;
    private final boolean streamDownload;
    private Exchange exchange;
    private String hostname;

    public SmbFile(SmbOperations operations, boolean download, boolean streamDownload) {
        this.operations = operations;
        this.download = download;
        this.streamDownload = streamDownload;
    }

    public void bindToExchange(Exchange exchange) {
        this.exchange = exchange;
        super.bindToExchange(exchange);
    }

    public void populateHeaders(GenericFileMessage<FileIdBothDirectoryInformation> message) {
        if (message != null) {
            super.populateHeaders(message, false);
            message.setHeader("CamelFileHost", (Object)this.getHostname());
        }
    }

    public void populateHeaders(GenericFileMessage<FileIdBothDirectoryInformation> message, boolean isProbeContentTypeFromEndpoint) {
        this.populateHeaders(message);
    }

    public String getHostname() {
        return this.hostname;
    }

    public void setHostname(String hostname) {
        this.hostname = hostname;
    }

    public char getFileSeparator() {
        return '/';
    }

    public void copyFromPopulateAdditional(GenericFile<FileIdBothDirectoryInformation> source, GenericFile<FileIdBothDirectoryInformation> result) {
        SmbFile remoteSource = (SmbFile)source;
        SmbFile remoteResult = (SmbFile)result;
        remoteResult.setHostname(remoteSource.getHostname());
    }

    public Object getBody() {
        if (!this.download) {
            return null;
        }
        if (this.streamDownload) {
            return this.operations.getBodyAsInputStream(this.exchange, this.getAbsoluteFilePath());
        }
        return this.operations.getBody(this.getAbsoluteFilePath());
    }

    public String toString() {
        return "SmbFile[" + (this.isAbsolute() ? this.getAbsoluteFilePath() : this.getRelativeFilePath()) + "]";
    }
}

