/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.smb;

import com.hierynomus.smbj.SmbConfig;
import java.net.URI;
import org.apache.camel.component.file.GenericFileConfiguration;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriParams;
import org.apache.camel.spi.UriPath;
import org.apache.camel.util.FileUtil;

@UriParams
public class SmbConfiguration
extends GenericFileConfiguration {
    private String protocol;
    @UriPath
    @Metadata(required=true)
    private String hostname;
    @UriPath(defaultValue="445")
    private int port = 445;
    @UriPath(description="The name of the share directory")
    @Metadata(required=true)
    private String shareName;
    @UriParam(label="common", description="The base directory within the share")
    private String path;
    @UriParam(label="security", description="The username required to access the share", secret=true)
    private String username;
    @UriParam(label="security", description="The password to access the share", secret=true)
    private String password;
    @UriParam(label="security", description="The user domain")
    private String domain;
    @UriParam(label="consumer", description="The search pattern used to list the files (server side on SMB). This parameter can contain the name of a file (or multiple files, if wildcards are used) within this directory. When it is null all files are included. Two wild card characters are supported in the search pattern. The ? (question mark) character matches a single character. If a search pattern contains one or more ? characters, then exactly that number of characters is matched by the wildcards. For example, the criterion ??x matches abx but not abcx or ax, because the two file names do not have enough characters preceding the literal. When a file name criterion has ? characters trailing a literal, then the match is made with specified number of characters or less. For example, the criterion x?? matches xab, xa, and x, but not xabc. If only ? characters are present in the file name selection criterion, then the match is made as if the criterion contained ? characters trailing a literal. The * (asterisk) character matches an entire file name. A null or empty specification criterion also selects all file names. For example, *.abc or .abc match any file with an extension of abc. *.*, *, or empty string match all files in a directory.")
    private String searchPattern;
    @UriParam(label="consumer", description="Sets the download method to use when not using a local working directory. If set to true, the remote files are streamed to the route as they are read. When set to false, the remote files are loaded into memory before being sent into the route.")
    @Metadata
    private boolean streamDownload;
    @UriParam(label="consumer,advanced", description="Whether the SMB consumer should download the file. If this option is set to false, then the message body will be null, but the consumer will still trigger a Camel Exchange that has details about the file such as file name, file size, etc. It's just that the file will not be downloaded.")
    private boolean download = true;
    @UriParam(label="common", description="Whether or not to disconnect from remote SMB share right after use. Disconnect will only disconnect the current connection to the SMB share. If you have a consumer which you want to stop, then you need to stop the consumer/route instead.")
    private boolean disconnect;
    @UriParam(label="producer,advanced", description="Whether or not to disconnect from remote SMB share right after a Batch upload is complete. disconnectOnBatchComplete will only disconnect the current connection to the SMB share.")
    private boolean disconnectOnBatchComplete;
    @UriParam(label="consumer,advanced", description="Should an exception be thrown if connection failed (exhausted). By default exception is not thrown and a <tt>WARN</tt> is logged. You can use this to enable exception being thrown and handle the thrown exception from the PollingConsumerPollStrategy rollback method.")
    private boolean throwExceptionOnConnectFailed;
    @UriParam(label="consumer,advanced", description="Whether the starting directory must exist. Mind that the autoCreate option is default enabled, which means the starting directory is normally auto created if it doesn't exist. You can disable autoCreate and enable this to ensure the starting directory must exist. Will throw an exception if the directory doesn't exist.")
    private boolean startingDirectoryMustExist;
    @Metadata(autowired=true)
    @UriParam(label="advanced", description="An optional SMB client configuration, can be used to configure client specific  configurations, like timeouts")
    private SmbConfig smbConfig;

    public SmbConfiguration() {
        this.setProtocol("smb");
    }

    public SmbConfiguration(URI uri) {
        super.setDirectory("");
        this.setProtocol(uri.getScheme());
        this.setHostname(uri.getHost());
        if (uri.getPort() > 0) {
            this.setPort(uri.getPort());
        }
        this.setShareName(FileUtil.stripLeadingSeparator((String)uri.getPath()));
    }

    public String getProtocol() {
        return this.protocol;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
        super.setDirectory(path);
    }

    public String getDirectory() {
        return super.getDirectory() == null ? "" : super.getDirectory();
    }

    public String getHostname() {
        return this.hostname;
    }

    public void setHostname(String hostname) {
        this.hostname = hostname;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String getShareName() {
        return this.shareName;
    }

    public void setShareName(String shareName) {
        this.shareName = shareName;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getDomain() {
        return this.domain;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    public String getSearchPattern() {
        return this.searchPattern;
    }

    public void setSearchPattern(String searchPattern) {
        this.searchPattern = searchPattern;
    }

    public boolean isStreamDownload() {
        return this.streamDownload;
    }

    public void setStreamDownload(boolean streamDownload) {
        this.streamDownload = streamDownload;
    }

    public boolean isDownload() {
        return this.download;
    }

    public void setDownload(boolean download) {
        this.download = download;
    }

    public boolean isDisconnect() {
        return this.disconnect;
    }

    public void setDisconnect(boolean disconnect) {
        this.disconnect = disconnect;
    }

    public boolean isDisconnectOnBatchComplete() {
        return this.disconnectOnBatchComplete;
    }

    public void setDisconnectOnBatchComplete(boolean disconnectOnBatchComplete) {
        this.disconnectOnBatchComplete = disconnectOnBatchComplete;
    }

    public boolean isThrowExceptionOnConnectFailed() {
        return this.throwExceptionOnConnectFailed;
    }

    public void setThrowExceptionOnConnectFailed(boolean throwExceptionOnConnectFailed) {
        this.throwExceptionOnConnectFailed = throwExceptionOnConnectFailed;
    }

    public boolean isStartingDirectoryMustExist() {
        return this.startingDirectoryMustExist;
    }

    public void setStartingDirectoryMustExist(boolean startingDirectoryMustExist) {
        this.startingDirectoryMustExist = startingDirectoryMustExist;
    }

    public SmbConfig getSmbConfig() {
        return this.smbConfig;
    }

    public void setSmbConfig(SmbConfig smbConfig) {
        this.smbConfig = smbConfig;
    }

    public String remoteServerInformation() {
        return this.protocol + "://" + (this.username != null ? this.username : "anonymous") + "@" + this.hostname + ":" + this.getPort();
    }
}

