/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.rest.openapi;

import java.util.Set;
import org.apache.camel.AsyncCallback;
import org.apache.camel.AsyncProducer;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.rest.openapi.RestOpenApiValidationException;
import org.apache.camel.component.rest.openapi.validator.RequestValidator;
import org.apache.camel.support.processor.DelegateAsyncProcessor;

public class RestOpenApiProducer
extends DelegateAsyncProcessor
implements AsyncProducer {
    private final Producer delegate;
    private final boolean removeHostHeader;
    private final RequestValidator requestValidator;

    public RestOpenApiProducer(Producer delegate, boolean removeHostHeader, RequestValidator requestValidator) {
        super((Processor)delegate);
        this.delegate = delegate;
        this.removeHostHeader = removeHostHeader;
        this.requestValidator = requestValidator;
    }

    public boolean process(Exchange exchange, AsyncCallback callback) {
        if (this.removeHostHeader) {
            exchange.getMessage().removeHeader("Host");
        }
        if (this.requestValidator != null) {
            try {
                Set<String> validationErrors = this.requestValidator.validate(exchange);
                if (!validationErrors.isEmpty()) {
                    RestOpenApiValidationException exception = new RestOpenApiValidationException(validationErrors);
                    exchange.setException((Throwable)exception);
                    callback.done(true);
                    return true;
                }
            }
            catch (Exception e) {
                exchange.setException((Throwable)e);
                callback.done(true);
                return true;
            }
        }
        return super.process(exchange, callback);
    }

    public Endpoint getEndpoint() {
        return this.delegate.getEndpoint();
    }

    public boolean isSingleton() {
        return this.delegate.isSingleton();
    }
}

