/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.rest.openapi;

import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.PathItem;
import io.swagger.v3.oas.models.media.Content;
import io.swagger.v3.oas.models.media.MediaType;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.parameters.Parameter;
import io.swagger.v3.oas.models.responses.ApiResponse;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.apache.camel.AsyncCallback;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.Consumer;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.RouteAware;
import org.apache.camel.Service;
import org.apache.camel.StartupStep;
import org.apache.camel.component.platform.http.spi.PlatformHttpConsumerAware;
import org.apache.camel.component.rest.openapi.RestOpenApiConsumerPath;
import org.apache.camel.component.rest.openapi.RestOpenApiEndpoint;
import org.apache.camel.component.rest.openapi.RestOpenapiProcessorStrategy;
import org.apache.camel.http.base.HttpHelper;
import org.apache.camel.spi.PackageScanClassResolver;
import org.apache.camel.spi.RestConfiguration;
import org.apache.camel.spi.StartupStepRecorder;
import org.apache.camel.support.PluginHelper;
import org.apache.camel.support.RestConsumerContextPathMatcher;
import org.apache.camel.support.processor.DelegateAsyncProcessor;
import org.apache.camel.support.processor.RestBindingAdvice;
import org.apache.camel.support.processor.RestBindingAdviceFactory;
import org.apache.camel.support.processor.RestBindingConfiguration;
import org.apache.camel.support.service.ServiceHelper;
import org.apache.camel.util.URISupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestOpenApiProcessor
extends DelegateAsyncProcessor
implements CamelContextAware {
    private static final Logger LOG = LoggerFactory.getLogger(RestOpenApiProcessor.class);
    private static final List<String> METHODS = Arrays.asList("GET", "HEAD", "POST", "PUT", "DELETE", "PATCH");
    private CamelContext camelContext;
    private final RestOpenApiEndpoint endpoint;
    private final OpenAPI openAPI;
    private final String basePath;
    private final String apiContextPath;
    private final List<RestConsumerContextPathMatcher.ConsumerPath<Operation>> paths = new ArrayList<RestConsumerContextPathMatcher.ConsumerPath<Operation>>();
    private final RestOpenapiProcessorStrategy restOpenapiProcessorStrategy;
    private final AtomicBoolean packageScanInit = new AtomicBoolean();
    private final Set<Class<?>> scannedClasses = new HashSet();
    private PlatformHttpConsumerAware platformHttpConsumer;
    private Consumer consumer;

    public RestOpenApiProcessor(RestOpenApiEndpoint endpoint, OpenAPI openAPI, String basePath, String apiContextPath, Processor processor, RestOpenapiProcessorStrategy restOpenapiProcessorStrategy) {
        super(processor);
        this.endpoint = endpoint;
        this.basePath = basePath;
        this.apiContextPath = apiContextPath != null && !apiContextPath.startsWith("/") ? "/" + apiContextPath : apiContextPath;
        this.openAPI = openAPI;
        this.restOpenapiProcessorStrategy = restOpenapiProcessorStrategy;
    }

    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    public PlatformHttpConsumerAware getPlatformHttpConsumer() {
        return this.platformHttpConsumer;
    }

    public void setPlatformHttpConsumer(PlatformHttpConsumerAware platformHttpConsumer) {
        this.platformHttpConsumer = platformHttpConsumer;
    }

    public Consumer getConsumer() {
        return this.consumer;
    }

    public void setConsumer(Consumer consumer) {
        this.consumer = consumer;
    }

    public boolean process(Exchange exchange, AsyncCallback callback) {
        String verb;
        RestConsumerContextPathMatcher.ConsumerPath m;
        String uri = (String)exchange.getMessage().getHeader("CamelHttpUri", String.class);
        if (uri != null) {
            uri = URISupport.stripQuery((String)uri);
        }
        if (uri != null && uri.startsWith(this.basePath)) {
            uri = uri.substring(this.basePath.length());
        }
        if ((m = RestConsumerContextPathMatcher.matchBestPath((String)(verb = (String)exchange.getMessage().getHeader("CamelHttpMethod", String.class)), (String)uri, this.paths)) instanceof RestOpenApiConsumerPath) {
            RestOpenApiConsumerPath rcp = (RestOpenApiConsumerPath)m;
            Operation o = rcp.getConsumer();
            RestConfiguration config = this.camelContext.getRestConfiguration();
            HttpHelper.evalPlaceholders((Map)exchange.getMessage().getHeaders(), (String)uri, (String)rcp.getConsumerPath());
            return this.restOpenapiProcessorStrategy.process(this.openAPI, o, verb, uri, rcp.getBinding(), exchange, callback);
        }
        if (uri != null && uri.equals(this.apiContextPath)) {
            return this.restOpenapiProcessorStrategy.processApiSpecification(this.endpoint.getSpecificationUri(), exchange, callback);
        }
        String contextPath = uri;
        List<String> allow = METHODS.stream().filter(v -> RestConsumerContextPathMatcher.matchBestPath((String)v, (String)contextPath, this.paths) != null).toList();
        if (allow.isEmpty()) {
            exchange.getMessage().setHeader("CamelHttpResponseCode", (Object)404);
        } else {
            exchange.getMessage().setHeader("CamelHttpResponseCode", (Object)405);
            exchange.getMessage().setHeader("Allow", (Object)String.join((CharSequence)", ", allow));
        }
        exchange.setRouteStop(true);
        callback.done(true);
        return true;
    }

    protected void doInit() throws Exception {
        super.doInit();
        CamelContextAware.trySetCamelContext((Object)this.restOpenapiProcessorStrategy, (CamelContext)this.getCamelContext());
        for (Map.Entry e : this.openAPI.getPaths().entrySet()) {
            String path = (String)e.getKey();
            for (Map.Entry o : ((PathItem)e.getValue()).readOperationsMap().entrySet()) {
                String desc;
                String v = ((PathItem.HttpMethod)o.getKey()).name();
                RestBindingConfiguration bc = this.createRestBindingConfiguration((Operation)o.getValue());
                String url = this.basePath + path;
                if (this.platformHttpConsumer != null) {
                    url = this.platformHttpConsumer.getPlatformHttpConsumer().getEndpoint().getServiceUrl() + url;
                }
                if ((desc = ((Operation)o.getValue()).getSummary()) != null && desc.isBlank()) {
                    desc = null;
                }
                String routeId = null;
                Consumer consumer = this.consumer;
                if (consumer instanceof RouteAware) {
                    RouteAware ra = (RouteAware)consumer;
                    routeId = ra.getRoute().getRouteId();
                }
                this.camelContext.getRestRegistry().addRestService(this.consumer, true, url, path, this.basePath, null, v, bc.getConsumes(), bc.getProduces(), bc.getType(), bc.getOutType(), routeId, desc);
                RestBindingAdvice binding = RestBindingAdviceFactory.build((CamelContext)this.camelContext, (RestBindingConfiguration)bc);
                RestBindingAdviceFactory.build((CamelContext)this.camelContext, (RestBindingConfiguration)bc);
                ServiceHelper.buildService((Object)binding);
                this.paths.add(new RestOpenApiConsumerPath(v, path, (Operation)o.getValue(), binding));
            }
        }
        this.scannedClasses.clear();
        this.restOpenapiProcessorStrategy.setMissingOperation(this.endpoint.getMissingOperation());
        this.restOpenapiProcessorStrategy.setMockIncludePattern(this.endpoint.getMockIncludePattern());
        ServiceHelper.initService((Object)this.restOpenapiProcessorStrategy);
        this.restOpenapiProcessorStrategy.validateOpenApi(this.openAPI, this.platformHttpConsumer);
    }

    private RestBindingConfiguration createRestBindingConfiguration(Operation o) throws Exception {
        Content c;
        Object c2;
        RestConfiguration config = this.camelContext.getRestConfiguration();
        RestConfiguration.RestBindingMode mode = config.getBindingMode();
        RestBindingConfiguration bc = new RestBindingConfiguration();
        bc.setBindingMode(mode.name());
        bc.setEnableCORS(config.isEnableCORS());
        bc.setCorsHeaders(config.getCorsHeaders());
        bc.setClientRequestValidation(config.isClientRequestValidation() || this.endpoint.isClientRequestValidation());
        bc.setEnableNoContentResponse(config.isEnableNoContentResponse());
        bc.setSkipBindingOnErrorCode(config.isSkipBindingOnErrorCode());
        String consumes = this.endpoint.getConsumes();
        String produces = this.endpoint.getProduces();
        if (o.getRequestBody() != null && (c2 = o.getRequestBody().getContent()) != null) {
            consumes = c2.keySet().stream().sorted().collect(Collectors.joining(","));
        }
        if (o.getResponses() != null) {
            for (ApiResponse a : o.getResponses().values()) {
                Content c3 = a.getContent();
                if (c3 == null) continue;
                produces = c3.keySet().stream().sorted().collect(Collectors.joining(","));
            }
        }
        bc.setConsumes(consumes);
        bc.setProduces(produces);
        boolean requiredBody = false;
        if (o.getRequestBody() != null) {
            requiredBody = Boolean.TRUE == o.getRequestBody().getRequired();
        }
        bc.setRequiredBody(requiredBody);
        Set requiredQueryParameters = null;
        if (o.getParameters() != null) {
            requiredQueryParameters = o.getParameters().stream().filter(p -> "query".equals(p.getIn())).filter(p -> Boolean.TRUE == p.getRequired()).map(Parameter::getName).collect(Collectors.toSet());
        }
        if (requiredQueryParameters != null) {
            bc.setRequiredQueryParameters(requiredQueryParameters);
        }
        Set requiredHeaders = null;
        if (o.getParameters() != null) {
            requiredHeaders = o.getParameters().stream().filter(p -> "header".equals(p.getIn())).filter(p -> Boolean.TRUE == p.getRequired()).map(Parameter::getName).collect(Collectors.toSet());
        }
        if (requiredHeaders != null) {
            bc.setRequiredHeaders(requiredHeaders);
        }
        Map<String, String> defaultQueryValues = null;
        if (o.getParameters() != null) {
            defaultQueryValues = o.getParameters().stream().filter(p -> "query".equals(p.getIn())).filter(p -> p.getSchema() != null).filter(p -> p.getSchema().getDefault() != null).collect(Collectors.toMap(Parameter::getName, p -> p.getSchema().getDefault().toString()));
        }
        if (defaultQueryValues != null) {
            bc.setQueryDefaultValues(defaultQueryValues);
        }
        if (o.getRequestBody() != null && (c = o.getRequestBody().getContent()) != null) {
            for (Map.Entry m : c.entrySet()) {
                Class<?> clazz;
                Schema s;
                String mt = (String)m.getKey();
                if (!mt.contains("json") && !mt.contains("xml") || (s = ((MediaType)m.getValue()).getSchema()) == null || s.getXml() == null) continue;
                String ref = s.getXml().getName();
                boolean array = "array".equals(s.getType());
                if (ref == null || (clazz = this.loadBindingClass(this.camelContext, ref)) == null) continue;
                Object name = clazz.getName();
                if (array) {
                    name = (String)name + "[]";
                }
                bc.setType((String)name);
                break;
            }
        }
        if (o.getResponses() != null) {
            block2: for (ApiResponse a : o.getResponses().values()) {
                Content c4 = a.getContent();
                if (c4 == null) continue;
                for (Map.Entry m : c4.entrySet()) {
                    Class<?> clazz;
                    Schema s;
                    String mt = (String)m.getKey();
                    if (!mt.contains("json") && !mt.contains("xml") || (s = ((MediaType)m.getValue()).getSchema()) == null || s.getXml() == null) continue;
                    String ref = s.getXml().getName();
                    boolean array = "array".equals(s.getType());
                    if (ref == null || (clazz = this.loadBindingClass(this.camelContext, ref)) == null) continue;
                    Object name = clazz.getName();
                    if (array) {
                        name = (String)name + "[]";
                    }
                    bc.setOutType((String)name);
                    continue block2;
                }
            }
        }
        return bc;
    }

    private Class<?> loadBindingClass(CamelContext camelContext, String ref) {
        String base;
        if (ref == null) {
            return null;
        }
        if (this.packageScanInit.compareAndSet(false, true) && (base = this.endpoint.getBindingPackageScan()) != null) {
            StartupStepRecorder recorder = camelContext.getCamelContextExtension().getStartupStepRecorder();
            StartupStep step = recorder.beginStep(RestOpenApiProcessor.class, "openapi-binding", "OpenAPI binding classes package scan");
            String[] pcks = base.split(",");
            PackageScanClassResolver resolver = PluginHelper.getPackageScanClassResolver((CamelContext)camelContext);
            this.scannedClasses.addAll(resolver.findImplementations(Object.class, pcks));
            if (!this.scannedClasses.isEmpty()) {
                LOG.info("Binding package scan found {} classes in packages: {}", (Object)this.scannedClasses.size(), (Object)base);
            }
            recorder.endStep(step);
        }
        ref = Character.toUpperCase(((String)ref).charAt(0)) + ((String)ref).substring(1);
        for (Class<?> clazz : this.scannedClasses) {
            if (!clazz.getSimpleName().equals(ref)) continue;
            return clazz;
        }
        return null;
    }

    protected void doStart() throws Exception {
        super.doStart();
        ServiceHelper.startService((Object)this.restOpenapiProcessorStrategy);
        for (RestConsumerContextPathMatcher.ConsumerPath<Operation> p : this.paths) {
            if (!(p instanceof RestOpenApiConsumerPath)) continue;
            RestOpenApiConsumerPath rcp = (RestOpenApiConsumerPath)p;
            ServiceHelper.startService((Service)rcp.getBinding());
        }
    }

    protected void doStop() throws Exception {
        super.doStop();
        ServiceHelper.stopService((Object)this.restOpenapiProcessorStrategy);
        for (RestConsumerContextPathMatcher.ConsumerPath<Operation> p : this.paths) {
            if (!(p instanceof RestOpenApiConsumerPath)) continue;
            RestOpenApiConsumerPath rcp = (RestOpenApiConsumerPath)p;
            ServiceHelper.stopService((Service)rcp.getBinding());
        }
        this.paths.clear();
    }
}

