/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.quickfixj;

import java.util.HashMap;
import java.util.Map;
import quickfix.ConfigError;
import quickfix.Dictionary;
import quickfix.SessionID;
import quickfix.SessionSettings;

public class QuickfixjConfiguration {
    private Map<Object, Object> defaultSettings;
    private Map<SessionID, Map<Object, Object>> sessionSettings;

    public Map<Object, Object> getDefaultSettings() {
        return this.defaultSettings;
    }

    public void setDefaultSettings(Map<Object, Object> defaultSettings) {
        this.defaultSettings = defaultSettings;
    }

    public Map<SessionID, Map<Object, Object>> getSessionSettings() {
        return this.sessionSettings;
    }

    public void setSessionSettings(Map<SessionID, Map<Object, Object>> sessionSettings) {
        this.sessionSettings = sessionSettings;
    }

    public void addSessionSetting(SessionID sessionID, Map<Object, Object> settings) {
        if (this.sessionSettings == null) {
            this.sessionSettings = new HashMap<SessionID, Map<Object, Object>>();
        }
        this.sessionSettings.put(sessionID, settings);
    }

    public SessionSettings createSessionSettings() throws ConfigError {
        SessionSettings settings = new SessionSettings();
        if (this.defaultSettings != null && !this.defaultSettings.isEmpty()) {
            settings.set(new Dictionary("defaults", this.defaultSettings));
        }
        if (this.sessionSettings != null && !this.sessionSettings.isEmpty()) {
            for (Map.Entry<SessionID, Map<Object, Object>> sessionSetting : this.sessionSettings.entrySet()) {
                settings.set(sessionSetting.getKey(), new Dictionary("session", sessionSetting.getValue()));
            }
        }
        return settings;
    }
}

