/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.qdrant;

import io.qdrant.client.PointIdFactory;
import io.qdrant.client.grpc.Points;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import org.apache.camel.Converter;

@Converter(generateLoader=true)
public class QdrantConverter {
    @Converter
    public static List<Points.PointStruct> toListOfPointStructs(Points.PointStruct p) {
        return Collections.singletonList(p);
    }

    @Converter
    public static List<Points.PointStruct> toListOfPointStructsFromCollection(Collection<Points.PointStruct> collection) {
        return new ArrayList<Points.PointStruct>(collection);
    }

    @Converter
    public static List<Points.PointId> toListOfPointIds(Points.PointId p) {
        return Collections.singletonList(p);
    }

    @Converter
    public static List<Points.PointId> toListOfPointIdsFromCollection(Collection<Points.PointId> collection) {
        return new ArrayList<Points.PointId>(collection);
    }

    @Converter
    public static Points.PointsSelector toPointSelector(Points.PointId id) {
        return Points.PointsSelector.newBuilder().setPoints(Points.PointsIdsList.newBuilder().addIds(id).build()).build();
    }

    @Converter
    public static Points.PointsSelector toPointSelector(Points.Condition condition) {
        return Points.PointsSelector.newBuilder().setFilter(Points.Filter.newBuilder().addMust(condition).build()).build();
    }

    @Converter
    public static Points.PointsSelector toPointSelector(Points.Filter filter) {
        return Points.PointsSelector.newBuilder().setFilter(filter).build();
    }

    @Converter
    public static Points.PointId toPointId(long id) {
        return PointIdFactory.id((long)id);
    }

    @Converter
    public static Points.PointId toPointId(Long id) {
        return PointIdFactory.id((long)id);
    }

    @Converter
    public static Points.PointId toPointId(UUID id) {
        return PointIdFactory.id((UUID)id);
    }
}

