/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.language.python;

import java.util.Map;
import org.apache.camel.Expression;
import org.apache.camel.ExpressionIllegalSyntaxException;
import org.apache.camel.Predicate;
import org.apache.camel.language.python.PythonExpression;
import org.apache.camel.spi.ScriptingLanguage;
import org.apache.camel.spi.annotations.Language;
import org.apache.camel.support.TypedLanguageSupport;
import org.python.core.PyObject;
import org.python.util.PythonInterpreter;

@Language(value="python")
public class PythonLanguage
extends TypedLanguageSupport
implements ScriptingLanguage {
    public Predicate createPredicate(String expression) {
        return this.createPythonExpression(expression, Boolean.class);
    }

    public Expression createExpression(String expression) {
        return this.createPythonExpression(expression, Object.class);
    }

    private PythonExpression createPythonExpression(String expression, Class<?> type) {
        return new PythonExpression(this.loadResource(expression), type);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <T> T evaluate(String script, Map<String, Object> bindings, Class<T> resultType) {
        script = this.loadResource(script);
        try (PythonInterpreter compiler = new PythonInterpreter();){
            PyObject out;
            if (bindings != null) {
                bindings.forEach((arg_0, arg_1) -> ((PythonInterpreter)compiler).set(arg_0, arg_1));
            }
            if ((out = compiler.eval(script)) == null) return null;
            String value = out.toString();
            Object object = this.getCamelContext().getTypeConverter().convertTo(resultType, (Object)value);
            return (T)object;
        }
        catch (Exception e) {
            throw new ExpressionIllegalSyntaxException(script, (Throwable)e);
        }
    }
}

