/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.paho.mqtt5;

import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.component.paho.mqtt5.PahoMqtt5Endpoint;
import org.apache.camel.support.DefaultProducer;
import org.eclipse.paho.mqttv5.client.MqttClient;
import org.eclipse.paho.mqttv5.client.MqttConnectionOptions;
import org.eclipse.paho.mqttv5.common.MqttMessage;
import org.eclipse.paho.mqttv5.common.packet.MqttProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PahoMqtt5Producer
extends DefaultProducer {
    private static final Logger LOG = LoggerFactory.getLogger(PahoMqtt5Producer.class);
    private volatile MqttClient client;
    private volatile String clientId;
    private volatile boolean stopClient;
    private volatile MqttConnectionOptions connectionOptions;

    public PahoMqtt5Producer(PahoMqtt5Endpoint endpoint) {
        super((Endpoint)endpoint);
    }

    public void process(Exchange exchange) throws Exception {
        String topic = (String)exchange.getIn().getHeader("CamelPahoMqtt5OverrideTopic", (Object)this.getEndpoint().getTopic(), String.class);
        int qos = (Integer)exchange.getIn().getHeader("CamelPahoMqtt5Qos", (Object)this.getEndpoint().getConfiguration().getQos(), Integer.class);
        boolean retained = (Boolean)exchange.getIn().getHeader("CamelPahoMqtt5Retained", (Object)this.getEndpoint().getConfiguration().isRetained(), Boolean.class);
        MqttProperties properties = (MqttProperties)exchange.getIn().getHeader("CamelPahoMqtt5MsgProperties", MqttProperties.class);
        byte[] payload = (byte[])exchange.getIn().getBody(byte[].class);
        MqttMessage message = new MqttMessage(payload);
        message.setQos(qos);
        message.setRetained(retained);
        message.setProperties(properties);
        LOG.debug("Publishing to topic: {}, qos: {}, retrained: {}", new Object[]{topic, qos, retained});
        this.client.publish(topic, message);
    }

    public PahoMqtt5Endpoint getEndpoint() {
        return (PahoMqtt5Endpoint)super.getEndpoint();
    }

    public MqttClient getClient() {
        return this.client;
    }

    public void setClient(MqttClient client) {
        this.client = client;
    }

    protected void doStart() throws Exception {
        super.doStart();
        this.connectionOptions = this.getEndpoint().createMqttConnectionOptions();
        if (this.client == null) {
            this.clientId = this.getEndpoint().getConfiguration().getClientId();
            if (this.clientId == null) {
                this.clientId = PahoMqtt5Endpoint.generateClientId();
            }
            this.stopClient = true;
            this.client = new MqttClient(this.getEndpoint().getConfiguration().getBrokerUrl(), this.clientId, PahoMqtt5Endpoint.createMqttClientPersistence(this.getEndpoint().getConfiguration()));
            LOG.debug("Connecting client: {} to broker: {}", (Object)this.clientId, (Object)this.getEndpoint().getConfiguration().getBrokerUrl());
            this.client.connect(this.connectionOptions);
        }
    }

    protected void doStop() throws Exception {
        super.doStop();
        if (this.stopClient && this.client != null && this.client.isConnected()) {
            LOG.debug("Disconnecting client: {} from broker: {}", (Object)this.clientId, (Object)this.getEndpoint().getConfiguration().getBrokerUrl());
            this.client.disconnect();
        }
        this.client = null;
    }
}

