/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.openstack.keystone.producer;

import java.util.List;
import java.util.Map;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.component.openstack.keystone.KeystoneEndpoint;
import org.apache.camel.component.openstack.keystone.producer.AbstractKeystoneProducer;
import org.apache.camel.util.StringHelper;
import org.openstack4j.api.Builders;
import org.openstack4j.api.OSClient;
import org.openstack4j.model.common.ActionResponse;
import org.openstack4j.model.identity.v3.Region;
import org.openstack4j.model.identity.v3.builder.RegionBuilder;

public class RegionProducer
extends AbstractKeystoneProducer {
    public RegionProducer(KeystoneEndpoint endpoint, OSClient client) {
        super(endpoint, client);
    }

    public void process(Exchange exchange) throws Exception {
        String operation;
        switch (operation = this.getOperation(exchange)) {
            case "create": {
                this.doCreate(exchange);
                break;
            }
            case "get": {
                this.doGet(exchange);
                break;
            }
            case "getAll": {
                this.doGetAll(exchange);
                break;
            }
            case "update": {
                this.doUpdate(exchange);
                break;
            }
            case "delete": {
                this.doDelete(exchange);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported operation " + operation);
            }
        }
    }

    private void doCreate(Exchange exchange) {
        Region in = this.messageToRegion(exchange.getIn());
        Region out = this.osV3Client.identity().regions().create(in);
        exchange.getIn().setBody((Object)out);
    }

    private void doGet(Exchange exchange) {
        String id = (String)exchange.getIn().getHeader("ID", String.class);
        StringHelper.notEmpty((String)id, (String)"Region ID");
        Region out = this.osV3Client.identity().regions().get(id);
        exchange.getIn().setBody((Object)out);
    }

    private void doGetAll(Exchange exchange) {
        List out = this.osV3Client.identity().regions().list();
        exchange.getIn().setBody((Object)out);
    }

    private void doUpdate(Exchange exchange) {
        Message msg = exchange.getIn();
        Region in = this.messageToRegion(msg);
        Region out = this.osV3Client.identity().regions().update(in);
        msg.setBody((Object)out);
    }

    private void doDelete(Exchange exchange) {
        Message msg = exchange.getIn();
        String id = (String)msg.getHeader("ID", String.class);
        StringHelper.notEmpty((String)id, (String)"Region ID");
        ActionResponse response = this.osV3Client.identity().regions().delete(id);
        this.checkFailure(response, exchange, "Delete network" + id);
    }

    private Region messageToRegion(Message message) {
        Region region = (Region)message.getBody(Region.class);
        if (region == null) {
            Map headers = message.getHeaders();
            RegionBuilder builder = Builders.region();
            if (headers.containsKey("description")) {
                builder.description((String)message.getHeader("description", String.class));
            }
            region = (Region)builder.build();
        }
        return region;
    }
}

