/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.netty.http;

import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.apache.camel.component.netty.http.SecurityConstraint;
import org.apache.camel.support.PatternHelper;

public class SecurityConstraintMapping
implements SecurityConstraint {
    private Map<String, String> inclusions;
    private Set<String> exclusions;

    @Override
    public String restricted(String url) {
        String roles;
        if (this.excludedUrl(url)) {
            return null;
        }
        String constraint = this.includedUrl(url);
        if (constraint == null) {
            return null;
        }
        String string = roles = this.inclusions != null ? this.inclusions.get(constraint) : null;
        if (roles == null) {
            return "*";
        }
        return roles;
    }

    private String includedUrl(String url) {
        String candidate = null;
        if (this.inclusions != null && !this.inclusions.isEmpty()) {
            for (String constraint : this.inclusions.keySet()) {
                if (!PatternHelper.matchPattern((String)url, (String)constraint)) continue;
                if (candidate == null) {
                    candidate = constraint;
                    continue;
                }
                if (constraint.length() <= candidate.length()) continue;
                candidate = constraint;
            }
            return candidate;
        }
        return "*";
    }

    private boolean excludedUrl(String url) {
        if (this.exclusions != null && !this.exclusions.isEmpty()) {
            for (String constraint : this.exclusions) {
                if (!PatternHelper.matchPattern((String)url, (String)constraint)) continue;
                return true;
            }
        }
        return false;
    }

    public void addInclusion(String constraint) {
        if (this.inclusions == null) {
            this.inclusions = new LinkedHashMap<String, String>();
        }
        this.inclusions.put(constraint, null);
    }

    public void addInclusion(String constraint, String roles) {
        if (this.inclusions == null) {
            this.inclusions = new LinkedHashMap<String, String>();
        }
        this.inclusions.put(constraint, roles);
    }

    public void addExclusion(String constraint) {
        if (this.exclusions == null) {
            this.exclusions = new LinkedHashSet<String>();
        }
        this.exclusions.add(constraint);
    }

    public void setInclusions(Map<String, String> inclusions) {
        this.inclusions = inclusions;
    }

    public void setExclusions(Set<String> exclusions) {
        this.exclusions = exclusions;
    }
}

