/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management.mbean;

import java.util.concurrent.TimeUnit;
import org.apache.camel.CamelContext;
import org.apache.camel.LoggingLevel;
import org.apache.camel.Service;
import org.apache.camel.api.management.ManagedResource;
import org.apache.camel.api.management.mbean.ManagedShutdownStrategyMBean;
import org.apache.camel.management.mbean.ManagedService;
import org.apache.camel.spi.ShutdownStrategy;

@ManagedResource(description="Managed ShutdownStrategy")
public class ManagedShutdownStrategy
extends ManagedService
implements ManagedShutdownStrategyMBean {
    private final ShutdownStrategy strategy;

    public ManagedShutdownStrategy(CamelContext context, ShutdownStrategy controller) {
        super(context, (Service)controller);
        this.strategy = controller;
    }

    public ShutdownStrategy getShutdownStrategy() {
        return this.strategy;
    }

    public void setTimeout(long timeout) {
        this.strategy.setTimeout(timeout);
    }

    public long getTimeout() {
        return this.strategy.getTimeout();
    }

    public void setTimeUnit(TimeUnit timeUnit) {
        this.strategy.setTimeUnit(timeUnit);
    }

    public TimeUnit getTimeUnit() {
        return this.strategy.getTimeUnit();
    }

    public void setSuppressLoggingOnTimeout(boolean suppressLoggingOnTimeout) {
        this.strategy.setSuppressLoggingOnTimeout(suppressLoggingOnTimeout);
    }

    public boolean isSuppressLoggingOnTimeout() {
        return this.strategy.isSuppressLoggingOnTimeout();
    }

    public void setShutdownNowOnTimeout(boolean shutdownNowOnTimeout) {
        this.strategy.setShutdownNowOnTimeout(shutdownNowOnTimeout);
    }

    public boolean isShutdownNowOnTimeout() {
        return this.strategy.isShutdownNowOnTimeout();
    }

    public void setShutdownRoutesInReverseOrder(boolean shutdownRoutesInReverseOrder) {
        this.strategy.setShutdownRoutesInReverseOrder(shutdownRoutesInReverseOrder);
    }

    public boolean isShutdownRoutesInReverseOrder() {
        return this.strategy.isShutdownRoutesInReverseOrder();
    }

    public void setLogInflightExchangesOnTimeout(boolean logInflightExchangesOnTimeout) {
        this.strategy.setLogInflightExchangesOnTimeout(logInflightExchangesOnTimeout);
    }

    public boolean isLogInflightExchangesOnTimeout() {
        return this.strategy.isLogInflightExchangesOnTimeout();
    }

    public boolean isForceShutdown() {
        return this.strategy.isForceShutdown();
    }

    public boolean isTimeoutOccurred() {
        return this.strategy.isTimeoutOccurred();
    }

    public String getLoggingLevel() {
        return this.strategy.getLoggingLevel().toString();
    }

    public void setLoggingLevel(String loggingLevel) {
        this.strategy.setLoggingLevel(LoggingLevel.valueOf((String)loggingLevel));
    }
}

