/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management.mbean;

import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.TabularData;
import javax.management.openmbean.TabularDataSupport;
import org.apache.camel.CamelContext;
import org.apache.camel.Processor;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.api.management.ManagedResource;
import org.apache.camel.api.management.mbean.CamelOpenMBeanTypes;
import org.apache.camel.api.management.mbean.ManagedSendProcessorMBean;
import org.apache.camel.management.mbean.ManagedProcessor;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.processor.SendProcessor;
import org.apache.camel.spi.ManagementStrategy;
import org.apache.camel.util.URISupport;

@ManagedResource(description="Managed SendProcessor")
public class ManagedSendProcessor
extends ManagedProcessor
implements ManagedSendProcessorMBean {
    private final SendProcessor processor;
    private String destination;

    public ManagedSendProcessor(CamelContext context, SendProcessor processor, ProcessorDefinition<?> definition) {
        super(context, (Processor)processor, definition);
        this.processor = processor;
    }

    @Override
    public void init(ManagementStrategy strategy) {
        super.init(strategy);
        boolean sanitize = strategy.getManagementAgent().getMask() != null ? strategy.getManagementAgent().getMask() : true;
        this.destination = sanitize ? URISupport.sanitizeUri((String)this.processor.getDestination().getEndpointUri()) : this.processor.getDestination().getEndpointUri();
    }

    @Override
    public Boolean getSupportExtendedInformation() {
        return true;
    }

    @Override
    public void reset() {
        super.reset();
        this.processor.reset();
    }

    public SendProcessor getProcessor() {
        return this.processor;
    }

    public String getDestination() {
        return this.destination;
    }

    public String getVariableSend() {
        return this.processor.getVariableSend();
    }

    public String getVariableReceive() {
        return this.processor.getVariableReceive();
    }

    public String getMessageExchangePattern() {
        if (this.processor.getPattern() != null) {
            return this.processor.getPattern().name();
        }
        return null;
    }

    public TabularData extendedInformation() {
        try {
            TabularDataSupport answer = new TabularDataSupport(CamelOpenMBeanTypes.endpointsUtilizationTabularType());
            CompositeType ct = CamelOpenMBeanTypes.endpointsUtilizationCompositeType();
            String url = this.getDestination();
            long hits = this.processor.getCounter();
            CompositeDataSupport data = new CompositeDataSupport(ct, new String[]{"url", "hits"}, new Object[]{url, hits});
            answer.put(data);
            return answer;
        }
        catch (Exception e) {
            throw RuntimeCamelException.wrapRuntimeCamelException((Throwable)e);
        }
    }
}

