/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.main;

import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.StringJoiner;
import org.apache.camel.CamelContext;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.builder.LambdaRouteBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.main.RoutesCollector;
import org.apache.camel.spi.PackageScanResourceResolver;
import org.apache.camel.spi.Resource;
import org.apache.camel.spi.RoutesLoader;
import org.apache.camel.support.PluginHelper;
import org.apache.camel.util.AntPathMatcher;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.StopWatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultRoutesCollector
implements RoutesCollector {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    private boolean ignoreLoadingError;

    @Override
    public boolean isIgnoreLoadingError() {
        return this.ignoreLoadingError;
    }

    @Override
    public void setIgnoreLoadingError(boolean ignoreLoadingError) {
        this.ignoreLoadingError = ignoreLoadingError;
    }

    @Override
    public Collection<RoutesBuilder> collectRoutesFromRegistry(CamelContext camelContext, String excludePattern, String includePattern) {
        ArrayList<RoutesBuilder> routes = new ArrayList<RoutesBuilder>();
        AntPathMatcher matcher = new AntPathMatcher();
        Collection<RoutesBuilder> additional = this.collectAdditionalRoutesFromRegistry(camelContext, excludePattern, includePattern);
        if (additional != null) {
            routes.addAll(additional);
        }
        Collection<LambdaRouteBuilder> lrbs = this.findByType(camelContext, LambdaRouteBuilder.class);
        for (final LambdaRouteBuilder lrb : lrbs) {
            RouteBuilder rb = new RouteBuilder(){

                public void configure() throws Exception {
                    lrb.accept((Object)this);
                }
            };
            routes.add((RoutesBuilder)rb);
        }
        Collection<RoutesBuilder> builders = this.findByType(camelContext, RoutesBuilder.class);
        for (RoutesBuilder routesBuilder : builders) {
            String[] parts;
            boolean abs = Modifier.isAbstract(routesBuilder.getClass().getModifiers());
            if (abs) continue;
            String name = routesBuilder.getClass().getName();
            name = name.replace('.', '/');
            boolean match = !"false".equals(includePattern);
            String exclude = camelContext.getCamelContextExtension().getTestExcludeRoutes();
            if (match && ObjectHelper.isNotEmpty((String)exclude)) {
                exclude = exclude.replace('.', '/');
                for (String part : parts = exclude.split(",")) {
                    match = !matcher.match(part, name);
                    this.log.trace("Java RoutesBuilder: {} exclude filter: {} -> {}", new Object[]{name, part, match});
                    if (!match) break;
                }
            }
            if (match && ObjectHelper.isNotEmpty((String)excludePattern)) {
                for (String part : parts = excludePattern.split(",")) {
                    match = !matcher.match(part, name);
                    this.log.trace("Java RoutesBuilder: {} exclude filter: {} -> {}", new Object[]{name, part, match});
                    if (!match) break;
                }
            }
            if (match && ObjectHelper.isNotEmpty((String)includePattern)) {
                for (String part : parts = includePattern.split(",")) {
                    match = matcher.match(part, name);
                    this.log.trace("Java RoutesBuilder: {} include filter: {} -> {}", new Object[]{name, part, match});
                    if (match) break;
                }
            }
            this.log.debug("Java RoutesBuilder: {} accepted by include/exclude filter: {}", (Object)name, (Object)match);
            if (!match) continue;
            routes.add(routesBuilder);
        }
        return routes;
    }

    @Override
    public Collection<RoutesBuilder> collectRoutesFromDirectory(CamelContext camelContext, String excludePattern, String includePattern) {
        ArrayList<RoutesBuilder> answer = new ArrayList<RoutesBuilder>();
        StopWatch watch = new StopWatch();
        String pattern = includePattern;
        String optionalPattern = null;
        if (pattern != null && pattern.contains("?optional=true")) {
            StringJoiner sj1 = new StringJoiner(",");
            StringJoiner sj2 = new StringJoiner(",");
            for (String p : pattern.split(",")) {
                if (p.endsWith("?optional=true")) {
                    sj2.add(p.substring(0, p.length() - 14));
                    continue;
                }
                sj1.add(p);
            }
            pattern = sj1.length() > 0 ? sj1.toString() : null;
            String string = optionalPattern = sj2.length() > 0 ? sj2.toString() : null;
        }
        if (optionalPattern == null) {
            this.doCollectRoutesFromDirectory(camelContext, answer, excludePattern, pattern, false);
        } else {
            this.doCollectRoutesFromDirectory(camelContext, answer, excludePattern, optionalPattern, true);
            if (pattern != null) {
                this.doCollectRoutesFromDirectory(camelContext, answer, excludePattern, pattern, false);
            }
        }
        if (!answer.isEmpty()) {
            this.log.debug("Loaded {} ({} millis) additional RoutesBuilder from: {}", new Object[]{answer.size(), watch.taken(), includePattern});
        } else {
            this.log.debug("No additional RoutesBuilder discovered from: {}", (Object)includePattern);
        }
        return answer;
    }

    protected void doCollectRoutesFromDirectory(CamelContext camelContext, List<RoutesBuilder> builders, String excludePattern, String includePattern, boolean optional) {
        RoutesLoader loader = PluginHelper.getRoutesLoader((CamelContext)camelContext);
        Collection<Resource> accepted = this.findRouteResourcesFromDirectory(camelContext, excludePattern, includePattern);
        try {
            Collection found = loader.findRoutesBuilders(accepted, optional);
            if (!found.isEmpty()) {
                this.log.debug("Found {} route builder from locations: {}", (Object)builders.size(), (Object)found);
                builders.addAll(found);
            }
        }
        catch (Exception e) {
            if (this.isIgnoreLoadingError()) {
                this.log.warn("Ignore Loading error: {} due to: {}. This exception is ignored.", accepted, (Object)e.getMessage());
            }
            throw RuntimeCamelException.wrapRuntimeException((Throwable)e);
        }
    }

    @Override
    public Collection<Resource> findRouteResourcesFromDirectory(CamelContext camelContext, String excludePattern, String includePattern) {
        String[] excludes;
        PackageScanResourceResolver resolver = PluginHelper.getPackageScanResourceResolver((CamelContext)camelContext);
        String[] includes = includePattern != null ? includePattern.split(",") : null;
        String[] stringArray = excludes = excludePattern != null ? excludePattern.split(",") : null;
        if (includes == null || ObjectHelper.equal((Object)"false", (Object)includePattern)) {
            this.log.debug("Include pattern is empty/false, no routes will be discovered from resources");
            return new ArrayList<Resource>();
        }
        ArrayList<Resource> accepted = new ArrayList<Resource>();
        for (String include : includes) {
            if (include.endsWith("?optional=true")) {
                include = include.substring(0, include.length() - 14);
            }
            this.log.debug("Finding additional routes from: {}", (Object)include);
            try {
                for (Resource resource : resolver.findResources(include)) {
                    if (!"false".equals(excludePattern) && AntPathMatcher.INSTANCE.anyMatch(excludes, resource.getLocation())) continue;
                    accepted.add(resource);
                }
            }
            catch (Exception e) {
                throw RuntimeCamelException.wrapRuntimeException((Throwable)e);
            }
        }
        return accepted;
    }

    protected Collection<RoutesBuilder> collectAdditionalRoutesFromRegistry(CamelContext camelContext, String excludePattern, String includePattern) {
        return null;
    }

    protected <T> Collection<T> findByType(CamelContext camelContext, Class<T> type) {
        return camelContext.getRegistry().findByType(type);
    }
}

