/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.langchain4j.chat;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import dev.langchain4j.agent.tool.ToolExecutionRequest;
import dev.langchain4j.data.message.AiMessage;
import dev.langchain4j.data.message.ChatMessage;
import dev.langchain4j.data.message.ToolExecutionResultMessage;
import dev.langchain4j.data.message.UserMessage;
import dev.langchain4j.model.chat.ChatLanguageModel;
import dev.langchain4j.model.input.Prompt;
import dev.langchain4j.model.input.PromptTemplate;
import dev.langchain4j.model.output.Response;
import dev.langchain4j.rag.content.injector.DefaultContentInjector;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.InvalidPayloadException;
import org.apache.camel.NoSuchHeaderException;
import org.apache.camel.component.langchain4j.chat.LangChain4jChatEndpoint;
import org.apache.camel.component.langchain4j.chat.LangChain4jChatOperations;
import org.apache.camel.component.langchain4j.chat.tool.CamelToolExecutorCache;
import org.apache.camel.component.langchain4j.chat.tool.CamelToolSpecification;
import org.apache.camel.support.DefaultProducer;
import org.apache.camel.util.ObjectHelper;

public class LangChain4jChatProducer
extends DefaultProducer {
    private final LangChain4jChatEndpoint endpoint;
    private ChatLanguageModel chatLanguageModel;
    private final ObjectMapper objectMapper = new ObjectMapper();

    public LangChain4jChatProducer(LangChain4jChatEndpoint endpoint) {
        super((Endpoint)endpoint);
        this.endpoint = endpoint;
    }

    public void process(Exchange exchange) throws Exception {
        LangChain4jChatOperations operation = this.endpoint.getConfiguration().getChatOperation();
        if (LangChain4jChatOperations.CHAT_SINGLE_MESSAGE.equals((Object)operation)) {
            this.processSingleMessage(exchange);
        } else if (LangChain4jChatOperations.CHAT_SINGLE_MESSAGE_WITH_PROMPT.equals((Object)operation)) {
            this.processSingleMessageWithPrompt(exchange);
        } else if (LangChain4jChatOperations.CHAT_MULTIPLE_MESSAGES.equals((Object)operation)) {
            this.processMultipleMessages(exchange);
        }
    }

    private void processSingleMessageWithPrompt(Exchange exchange) throws NoSuchHeaderException, InvalidPayloadException {
        String promptTemplate = (String)exchange.getIn().getHeader("CamelLangChain4jChatPromptTemplate", String.class);
        if (promptTemplate == null) {
            throw new NoSuchHeaderException("The promptTemplate is a required header", exchange, "CamelLangChain4jChatPromptTemplate");
        }
        Map variables = (Map)exchange.getIn().getMandatoryBody(Map.class);
        String response = this.sendWithPromptTemplate(promptTemplate, variables, exchange);
        this.populateResponse(response, exchange);
    }

    private void processSingleMessage(Exchange exchange) throws InvalidPayloadException {
        Object message = exchange.getIn().getMandatoryBody();
        UserMessage userMessage = message instanceof String ? new UserMessage((String)message) : (ChatMessage)message;
        this.populateResponse(this.sendChatMessage((ChatMessage)userMessage, exchange), exchange);
    }

    private void processMultipleMessages(Exchange exchange) throws InvalidPayloadException {
        List messages = (List)exchange.getIn().getMandatoryBody(List.class);
        this.populateResponse(this.sendListChatMessage(messages, exchange), exchange);
    }

    protected void doStart() throws Exception {
        super.doStart();
        this.chatLanguageModel = this.endpoint.getConfiguration().getChatModel();
        ObjectHelper.notNull((Object)this.chatLanguageModel, (String)"chatLanguageModel");
    }

    private void populateResponse(String response, Exchange exchange) {
        exchange.getMessage().setBody((Object)response);
    }

    private String sendChatMessage(ChatMessage chatMessage, Exchange exchange) {
        ChatMessage augmentedChatMessage = this.addAugmentedData(chatMessage, exchange);
        Response response = this.chatLanguageModel.generate(new ChatMessage[]{augmentedChatMessage});
        return this.extractAiResponse((Response<AiMessage>)response);
    }

    private ChatMessage addAugmentedData(ChatMessage chatMessage, Exchange exchange) {
        List augmentedData = (List)exchange.getIn().getHeader("CamelLangChain4jChatAugmentedData", List.class);
        if (augmentedData != null && augmentedData.size() != 0) {
            DefaultContentInjector contentInjector = new DefaultContentInjector();
            return contentInjector.inject(augmentedData, chatMessage);
        }
        return chatMessage;
    }

    private String sendListChatMessage(List<ChatMessage> chatMessages, Exchange exchange) {
        Response response;
        Map<String, Set<CamelToolSpecification>> tools;
        int lastIndex;
        ChatMessage lastUserMessage;
        LangChain4jChatEndpoint langChain4jChatEndpoint = (LangChain4jChatEndpoint)this.getEndpoint();
        int size = chatMessages.size();
        if (size != 0 && (lastUserMessage = chatMessages.get(lastIndex = size - 1)) instanceof UserMessage) {
            chatMessages.set(lastIndex, this.addAugmentedData(lastUserMessage, exchange));
        }
        if ((tools = CamelToolExecutorCache.getInstance().getTools()).containsKey(langChain4jChatEndpoint.getChatId())) {
            Set<CamelToolSpecification> camelToolSpecificationSet = tools.get(langChain4jChatEndpoint.getChatId());
            List toolSpecifications = camelToolSpecificationSet.stream().map(camelToolSpecification -> camelToolSpecification.getToolSpecification()).collect(Collectors.toList());
            response = this.chatLanguageModel.generate(chatMessages, toolSpecifications);
        } else {
            response = this.chatLanguageModel.generate(chatMessages);
        }
        if (((AiMessage)response.content()).hasToolExecutionRequests()) {
            chatMessages.add((ChatMessage)response.content());
            for (ToolExecutionRequest toolExecutionRequest : ((AiMessage)response.content()).toolExecutionRequests()) {
                String toolName = toolExecutionRequest.name();
                CamelToolSpecification camelToolSpecification2 = CamelToolExecutorCache.getInstance().getTools().get(langChain4jChatEndpoint.getChatId()).stream().filter(cts -> cts.getToolSpecification().name().equals(toolName)).findFirst().orElseThrow(() -> new RuntimeException("Tool " + toolName + " not found"));
                try {
                    JsonNode jsonNode = (JsonNode)this.objectMapper.readValue(toolExecutionRequest.arguments(), JsonNode.class);
                    jsonNode.fieldNames().forEachRemaining(name -> exchange.getMessage().setHeader(name, (Object)jsonNode.get(name)));
                    camelToolSpecification2.getConsumer().getProcessor().process(exchange);
                }
                catch (Exception e) {
                    exchange.setException((Throwable)e);
                }
                chatMessages.add((ChatMessage)new ToolExecutionResultMessage(toolExecutionRequest.id(), toolExecutionRequest.name(), (String)exchange.getIn().getBody(String.class)));
            }
            response = this.chatLanguageModel.generate(chatMessages);
        }
        return this.extractAiResponse((Response<AiMessage>)response);
    }

    private String extractAiResponse(Response<AiMessage> response) {
        AiMessage message = (AiMessage)response.content();
        return message == null ? null : message.text();
    }

    public String sendWithPromptTemplate(String promptTemplate, Map<String, Object> variables, Exchange exchange) {
        PromptTemplate template = PromptTemplate.from((String)promptTemplate);
        Prompt prompt = template.apply(variables);
        return this.sendChatMessage((ChatMessage)new UserMessage(prompt.text()), exchange);
    }
}

