/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.karaf.shell;

import java.util.List;
import org.apache.camel.CamelContext;
import org.apache.camel.karaf.shell.CamelCommandSupport;
import org.apache.camel.karaf.shell.completers.CamelContextCompleter;
import org.apache.karaf.shell.api.action.Action;
import org.apache.karaf.shell.api.action.Argument;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.Completion;
import org.apache.karaf.shell.api.action.lifecycle.Service;

@Command(scope="camel", name="rest-api-doc", description="List the Camel REST services API documentation (requires camel-swagger-java on classpath)")
@Service
public class RestApiDoc
extends CamelCommandSupport
implements Action {
    @Argument(index=0, name="context", description="The Camel context name where to look for the REST services", required=false, multiValued=false)
    @Completion(value=CamelContextCompleter.class)
    String name;

    public Object execute() throws Exception {
        List<CamelContext> camelContexts = this.getCamelContext(this.name);
        if (camelContexts.size() != 1) {
            System.err.println("Camel context " + this.name + " not found");
            return null;
        }
        String json = camelContexts.get(0).getRestRegistry().apiDocAsJson();
        if (json != null) {
            System.out.println(json);
        } else {
            System.out.println("There is no REST service");
        }
        return null;
    }
}

