/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.karaf.shell;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.TabularData;
import org.apache.camel.CamelContext;
import org.apache.camel.karaf.shell.CamelCommandSupport;
import org.apache.camel.karaf.shell.completers.CamelContextCompleter;
import org.apache.camel.karaf.shell.completers.RouteCompleter;
import org.apache.camel.spi.ManagementAgent;
import org.apache.karaf.shell.api.action.Action;
import org.apache.karaf.shell.api.action.Argument;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.Completion;
import org.apache.karaf.shell.api.action.Option;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.apache.karaf.shell.support.table.ShellTable;

@Command(scope="camel", name="context-inflight", description="List inflight exchanges")
@Service
public class ContextInflight
extends CamelCommandSupport
implements Action {
    @Argument(index=0, name="context", description="The Camel context name", required=false, multiValued=false)
    @Completion(value=CamelContextCompleter.class)
    String name;
    @Option(name="--limit", aliases={"-l"}, description="To limit the number of exchanges shown", required=false, multiValued=false)
    int limit = -1;
    @Argument(index=1, name="route", description="The Camel route ID", required=false, multiValued=false)
    @Completion(value=RouteCompleter.class)
    String route;
    @Option(name="--sort", aliases={"-s"}, description="Sort by longest duration (true) or by exchange id (false)", required=false, multiValued=false, valueToShowInHelp="false")
    boolean sortByLongestDuration;

    public Object execute() throws Exception {
        List<CamelContext> camelContexts = this.getCamelContext(this.name);
        ShellTable table = new ShellTable();
        table.column("ExchangeId");
        table.column("From Route");
        table.column("Context");
        table.column("Route");
        table.column("Node");
        table.column("Elapsed (ms)");
        table.column("Duration (ms)");
        for (CamelContext camelContext : camelContexts) {
            ObjectName on;
            MBeanServer mBeanServer;
            ManagementAgent agent = camelContext.getManagementStrategy().getManagementAgent();
            if (agent == null || !(mBeanServer = agent.getMBeanServer()).isRegistered(on = new ObjectName(agent.getMBeanObjectDomainName() + ":type=services,name=DefaultInflightRepository,context=" + camelContext.getManagementName()))) continue;
            TabularData list = (TabularData)mBeanServer.invoke(on, "browse", new Object[]{this.route, this.limit, this.sortByLongestDuration}, new String[]{"java.lang.String", "int", "boolean"});
            Collection<?> values = list.values();
            for (CompositeData data : values) {
                LinkedHashMap row = new LinkedHashMap();
                Object exchangeId = data.get("exchangeId");
                Object fromRouteId = data.get("fromRouteId");
                Object routeId = data.get("routeId");
                Object nodeId = data.get("nodeId");
                Object elapsed = data.get("elapsed");
                Object duration = data.get("duration");
                table.addRow().addContent(new Object[]{exchangeId, fromRouteId, camelContext.getName(), routeId, nodeId, elapsed, duration});
            }
        }
        table.print(System.out);
        return null;
    }
}

