/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.karaf.commands.internal;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.api.management.ManagedCamelContext;
import org.apache.camel.commands.AbstractLocalCamelController;
import org.apache.camel.support.ObjectHelper;
import org.apache.karaf.shell.api.action.lifecycle.Reference;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CamelControllerImpl
extends AbstractLocalCamelController {
    private static final Logger LOG = LoggerFactory.getLogger(CamelControllerImpl.class);
    @Reference
    private BundleContext bundleContext;

    public void setBundleContext(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    public List<CamelContext> getLocalCamelContexts() {
        ArrayList<CamelContext> camelContexts = new ArrayList<CamelContext>();
        try {
            ServiceReference[] references = this.bundleContext.getServiceReferences(CamelContext.class.getName(), null);
            if (references != null) {
                for (ServiceReference reference : references) {
                    CamelContext camelContext;
                    if (reference == null || (camelContext = (CamelContext)this.bundleContext.getService(reference)) == null) continue;
                    camelContexts.add(camelContext);
                }
            }
        }
        catch (Exception e) {
            LOG.warn("Cannot retrieve the list of Camel contexts. This exception is ignored.", (Throwable)e);
        }
        camelContexts.sort(Comparator.comparing(CamelContext::getName));
        return camelContexts;
    }

    public List<Map<String, String>> getCamelContexts() throws Exception {
        ArrayList<Map<String, String>> answer = new ArrayList<Map<String, String>>();
        List<CamelContext> camelContexts = this.getLocalCamelContexts();
        for (CamelContext camelContext : camelContexts) {
            LinkedHashMap<String, Object> row = new LinkedHashMap<String, Object>();
            row.put("name", camelContext.getName());
            row.put("state", camelContext.getStatus().name());
            row.put("uptime", camelContext.getUptime());
            ManagedCamelContext mcc = (ManagedCamelContext)camelContext.getExtension(ManagedCamelContext.class);
            if (mcc != null && mcc.getManagedCamelContext() != null) {
                row.put("exchangesTotal", "" + mcc.getManagedCamelContext().getExchangesTotal());
                row.put("exchangesInflight", "" + mcc.getManagedCamelContext().getExchangesInflight());
                row.put("exchangesFailed", "" + mcc.getManagedCamelContext().getExchangesFailed());
            } else {
                row.put("exchangesTotal", "0");
                row.put("exchangesInflight", "0");
                row.put("exchangesFailed", "0");
            }
            answer.add(row);
        }
        return answer;
    }

    public void startContext(String camelContextName) throws Exception {
        CamelContext context = this.getLocalCamelContext(camelContextName);
        if (context != null) {
            ObjectHelper.callWithTCCL(() -> {
                context.start();
                return null;
            }, (ClassLoader)this.getClassLoader(context));
        }
    }

    public void resumeContext(String camelContextName) throws Exception {
        CamelContext context = this.getLocalCamelContext(camelContextName);
        if (context != null) {
            ObjectHelper.callWithTCCL(() -> {
                context.resume();
                return null;
            }, (ClassLoader)this.getClassLoader(context));
        }
    }

    public void startRoute(String camelContextName, String routeId) throws Exception {
        CamelContext context = this.getLocalCamelContext(camelContextName);
        if (context != null) {
            ObjectHelper.callWithTCCL(() -> {
                context.getRouteController().startRoute(routeId);
                return null;
            }, (ClassLoader)this.getClassLoader(context));
        }
    }

    public void resumeRoute(String camelContextName, String routeId) throws Exception {
        CamelContext context = this.getLocalCamelContext(camelContextName);
        if (context != null) {
            ObjectHelper.callWithTCCL(() -> {
                context.getRouteController().resumeRoute(routeId);
                return null;
            }, (ClassLoader)this.getClassLoader(context));
        }
    }

    private ClassLoader getClassLoader(CamelContext context) {
        return context.getApplicationContextClassLoader();
    }
}

