/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.kamelet.utils.transform;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangeProperty;
import org.apache.camel.InvalidPayloadException;
import org.apache.camel.util.ObjectHelper;

public class ReplaceField {
    public JsonNode process(@ExchangeProperty(value="enabled") String enabled, @ExchangeProperty(value="disabled") String disabled, @ExchangeProperty(value="renames") String renames, Exchange ex) throws InvalidPayloadException {
        ObjectMapper mapper = new ObjectMapper();
        ArrayList<String> enabledFields = new ArrayList();
        ArrayList<String> disabledFields = new ArrayList();
        ArrayList<String> renameFields = new ArrayList();
        JsonNode jsonNodeBody = (JsonNode)ex.getMessage().getBody(JsonNode.class);
        Map body = (Map)mapper.convertValue((Object)jsonNodeBody, (TypeReference)new TypeReference<Map<Object, Object>>(){});
        if (ObjectHelper.isNotEmpty((String)enabled) && !enabled.equalsIgnoreCase("all")) {
            enabledFields = Arrays.stream(enabled.split(",")).collect(Collectors.toList());
        }
        if (ObjectHelper.isNotEmpty((String)disabled) && !disabled.equalsIgnoreCase("none")) {
            disabledFields = Arrays.stream(disabled.split(",")).collect(Collectors.toList());
        }
        if (ObjectHelper.isNotEmpty((String)disabled)) {
            renameFields = Arrays.stream(renames.split(",")).collect(Collectors.toList());
        }
        HashMap updatedBody = new HashMap();
        if (ObjectHelper.isNotEmpty(renameFields)) {
            Map<String, String> renamingMap = ReplaceField.parseNames(renameFields);
            for (Map.Entry entry : body.entrySet()) {
                String fieldName = (String)entry.getKey();
                if (!this.filterNames(fieldName, enabledFields, disabledFields)) continue;
                Object fieldValue = entry.getValue();
                updatedBody.put(this.renameOptional(fieldName, renamingMap), fieldValue);
            }
        }
        if (!updatedBody.isEmpty()) {
            return mapper.valueToTree(updatedBody);
        }
        return mapper.valueToTree((Object)body);
    }

    boolean filterNames(String fieldName, List<String> enabledFields, List<String> disabledFields) {
        return !disabledFields.contains(fieldName) && (enabledFields.isEmpty() || enabledFields.contains(fieldName));
    }

    static Map<String, String> parseNames(List<String> mappings) {
        HashMap<String, String> m = new HashMap<String, String>();
        for (String mapping : mappings) {
            String[] parts = mapping.split(":");
            m.put(parts[0], parts[1]);
        }
        return m;
    }

    String renameOptional(String fieldName, Map<String, String> renames) {
        String mapping = renames.get(fieldName);
        return mapping == null ? fieldName : mapping;
    }
}

