/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.kamelet.utils.transform;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangeProperty;
import org.apache.camel.util.ObjectHelper;

public class MessageTimestampRouter {
    public void process(@ExchangeProperty(value="topicFormat") String topicFormat, @ExchangeProperty(value="timestampFormat") String timestampFormat, @ExchangeProperty(value="timestampKeys") String timestampKeys, @ExchangeProperty(value="timestampKeyFormat") String timestampKeyFormat, Exchange ex) throws ParseException {
        Pattern TOPIC = Pattern.compile("$[topic]", 16);
        Pattern TIMESTAMP = Pattern.compile("$[timestamp]", 16);
        SimpleDateFormat fmt = new SimpleDateFormat(timestampFormat);
        fmt.setTimeZone(TimeZone.getTimeZone("UTC"));
        ObjectMapper mapper = new ObjectMapper();
        List<Object> splittedKeys = new ArrayList();
        JsonNode jsonNodeBody = (JsonNode)ex.getMessage().getBody(JsonNode.class);
        Map body = (Map)mapper.convertValue((Object)jsonNodeBody, (TypeReference)new TypeReference<Map<Object, Object>>(){});
        if (ObjectHelper.isNotEmpty((String)timestampKeys)) {
            splittedKeys = Arrays.stream(timestampKeys.split(",")).collect(Collectors.toList());
        }
        Object rawTimestamp = null;
        String topicName = (String)ex.getMessage().getHeader("kafka.TOPIC", String.class);
        for (String string : splittedKeys) {
            if (!ObjectHelper.isNotEmpty((String)string)) continue;
            rawTimestamp = body.get(string);
            break;
        }
        Long timestamp = null;
        if (ObjectHelper.isNotEmpty((String)timestampKeyFormat) && ObjectHelper.isNotEmpty(rawTimestamp) && !timestampKeyFormat.equalsIgnoreCase("timestamp")) {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat(timestampKeyFormat);
            simpleDateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
            timestamp = simpleDateFormat.parse((String)rawTimestamp).getTime();
        } else if (ObjectHelper.isNotEmpty(rawTimestamp)) {
            timestamp = Long.parseLong(rawTimestamp.toString());
        }
        if (ObjectHelper.isNotEmpty(timestamp)) {
            String updatedTopic;
            String string = fmt.format(new Date(timestamp));
            if (ObjectHelper.isNotEmpty((String)topicName)) {
                String replace1 = TOPIC.matcher(topicFormat).replaceAll(Matcher.quoteReplacement(topicName));
                updatedTopic = TIMESTAMP.matcher(replace1).replaceAll(Matcher.quoteReplacement(string));
            } else {
                String replace1 = TOPIC.matcher(topicFormat).replaceAll(Matcher.quoteReplacement(""));
                updatedTopic = TIMESTAMP.matcher(replace1).replaceAll(Matcher.quoteReplacement(string));
            }
            ex.getMessage().setHeader("kafka.OVERRIDE_TOPIC", (Object)updatedTopic);
        }
    }
}

