/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jooq;

import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.Message;
import org.apache.camel.component.jooq.JooqConfiguration;
import org.apache.camel.component.jooq.JooqEndpoint;
import org.apache.camel.component.jooq.JooqOperation;
import org.apache.camel.support.DefaultProducer;
import org.apache.camel.util.ObjectHelper;
import org.jooq.Configuration;
import org.jooq.DSLContext;
import org.jooq.Query;
import org.jooq.Result;
import org.jooq.ResultQuery;
import org.jooq.UpdatableRecord;
import org.jooq.impl.DSL;

public class JooqProducer
extends DefaultProducer {
    private final Expression expression;
    private JooqEndpoint endpoint;

    public JooqProducer(JooqEndpoint endpoint, Expression expression) {
        super((Endpoint)endpoint);
        this.expression = expression;
        this.endpoint = endpoint;
    }

    public void process(Exchange exchange) {
        JooqConfiguration configuration = this.endpoint.getConfiguration();
        Configuration dbConfig = configuration.getDatabaseConfiguration();
        JooqOperation operation = configuration.getOperation();
        String querySQL = configuration.getQuery();
        switch (operation) {
            case EXECUTE: {
                if (ObjectHelper.isEmpty((String)querySQL)) {
                    Query query = (Query)this.expression.evaluate(exchange, Query.class);
                    query.attach(dbConfig);
                    query.execute();
                    break;
                }
                DSLContext context = DSL.using((Configuration)dbConfig);
                context.execute(querySQL);
                break;
            }
            case FETCH: {
                Result result;
                if (ObjectHelper.isEmpty((String)querySQL)) {
                    ResultQuery resultQuery = (ResultQuery)this.expression.evaluate(exchange, ResultQuery.class);
                    resultQuery.attach(dbConfig);
                    result = resultQuery.fetch();
                } else {
                    DSLContext context = DSL.using((Configuration)dbConfig);
                    result = context.fetch(querySQL);
                }
                Message target = exchange.getPattern().isOutCapable() ? exchange.getOut() : exchange.getIn();
                target.setBody((Object)result);
                break;
            }
            case NONE: {
                DSLContext context = DSL.using((Configuration)dbConfig);
                UpdatableRecord entity = (UpdatableRecord)this.expression.evaluate(exchange, UpdatableRecord.class);
                context.batchStore(new UpdatableRecord[]{entity}).execute();
                break;
            }
            default: {
                throw new IllegalArgumentException("Wrong operation: " + String.valueOf((Object)operation));
            }
        }
    }
}

