/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jira.producer;

import com.atlassian.jira.rest.client.api.IssueRestClient;
import com.atlassian.jira.rest.client.api.JiraRestClient;
import com.atlassian.jira.rest.client.api.domain.IssueFieldId;
import com.atlassian.jira.rest.client.api.domain.IssueType;
import com.atlassian.jira.rest.client.api.domain.Priority;
import com.atlassian.jira.rest.client.api.domain.input.ComplexIssueInputFieldValue;
import com.atlassian.jira.rest.client.api.domain.input.FieldInput;
import com.atlassian.jira.rest.client.api.domain.input.IssueInputBuilder;
import java.util.ArrayList;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.component.jira.JiraEndpoint;
import org.apache.camel.support.DefaultProducer;
import org.apache.camel.util.ObjectHelper;

public class UpdateIssueProducer
extends DefaultProducer {
    public UpdateIssueProducer(JiraEndpoint endpoint) {
        super((Endpoint)endpoint);
    }

    public void process(Exchange exchange) {
        String description;
        JiraRestClient client = ((JiraEndpoint)this.getEndpoint()).getClient();
        String issueKey = (String)exchange.getIn().getHeader("IssueKey", String.class);
        if (issueKey == null) {
            throw new IllegalArgumentException("Missing exchange input header named 'IssueKey', it should specify the issue key.");
        }
        Long issueTypeId = (Long)exchange.getIn().getHeader("IssueTypeId", Long.class);
        String issueTypeName = (String)exchange.getIn().getHeader("IssueTypeName", String.class);
        String summary = (String)exchange.getIn().getHeader("IssueSummary", String.class);
        String assigneeName = (String)exchange.getIn().getHeader("IssueAssignee", String.class);
        String assigneeId = (String)exchange.getIn().getHeader("IssueAssigneeId", String.class);
        String priorityName = (String)exchange.getIn().getHeader("IssuePriorityName", String.class);
        Long priorityId = (Long)exchange.getIn().getHeader("IssuePriorityId", Long.class);
        String components = (String)exchange.getIn().getHeader("IssueComponents", String.class);
        if (issueTypeId == null && issueTypeName != null) {
            Iterable issueTypes = (Iterable)client.getMetadataClient().getIssueTypes().claim();
            for (IssueType type : issueTypes) {
                if (!issueTypeName.equals(type.getName())) continue;
                issueTypeId = type.getId();
                break;
            }
        }
        if (priorityId == null && priorityName != null) {
            Iterable priorities = (Iterable)client.getMetadataClient().getPriorities().claim();
            for (Priority pri : priorities) {
                if (!priorityName.equals(pri.getName())) continue;
                priorityId = pri.getId();
                break;
            }
        }
        IssueInputBuilder builder = new IssueInputBuilder();
        if (issueTypeId != null) {
            builder.setIssueTypeId(issueTypeId);
        }
        if (summary != null) {
            builder.setSummary(summary);
        }
        if ((description = (String)exchange.getIn().getBody(String.class)) != null) {
            builder.setDescription(description);
        }
        if (ObjectHelper.isNotEmpty((String)components)) {
            String[] compArr = components.split(",");
            ArrayList<String> comps = new ArrayList<String>(compArr.length);
            for (String s : compArr) {
                comps.add(s.trim());
            }
            builder.setComponentsNames(comps);
        }
        if (priorityId != null) {
            builder.setPriorityId(priorityId);
        }
        if (assigneeName != null) {
            builder.setAssigneeName(assigneeName);
        } else if (assigneeId != null) {
            builder.setFieldInput(new FieldInput(IssueFieldId.ASSIGNEE_FIELD, (Object)ComplexIssueInputFieldValue.with((String)"id", (Object)assigneeId)));
        }
        IssueRestClient issueClient = client.getIssueClient();
        issueClient.updateIssue(issueKey, builder.build()).claim();
    }
}

