/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.language.js;

import java.util.Map;
import org.apache.camel.Expression;
import org.apache.camel.Predicate;
import org.apache.camel.language.js.JavaScriptExpression;
import org.apache.camel.language.js.JavaScriptHelper;
import org.apache.camel.spi.ScriptingLanguage;
import org.apache.camel.spi.annotations.Language;
import org.apache.camel.support.TypedLanguageSupport;
import org.graalvm.polyglot.Context;
import org.graalvm.polyglot.Source;
import org.graalvm.polyglot.Value;

@Language(value="js")
public class JavaScriptLanguage
extends TypedLanguageSupport
implements ScriptingLanguage {
    public Predicate createPredicate(String expression) {
        return this.createJavaScriptExpression(expression, Boolean.class);
    }

    public Expression createExpression(String expression) {
        return this.createJavaScriptExpression(expression, Object.class);
    }

    public <T> T evaluate(String script, Map<String, Object> bindings, Class<T> resultType) {
        script = this.loadResource(script);
        try (Context cx = JavaScriptHelper.newContext();){
            Value b = cx.getBindings("js");
            bindings.forEach((arg_0, arg_1) -> ((Value)b).putMember(arg_0, arg_1));
            Source source = Source.newBuilder((String)"js", (CharSequence)script, (String)"Unnamed").mimeType("application/javascript+module").buildLiteral();
            Value o = cx.eval(source);
            Object answer = o != null ? o.as(resultType) : null;
            T t = resultType.cast(answer);
            return t;
        }
    }

    private JavaScriptExpression createJavaScriptExpression(String expression, Class<?> type) {
        return new JavaScriptExpression(this.loadResource(expression), type);
    }
}

