/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.influxdb2.data;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.camel.component.influxdb2.data.Record;

public class Records {
    private List<Record> records = new ArrayList<Record>();

    public Records() {
    }

    private Records(List<Record> records) {
        this.records = records;
    }

    public List<String> getInfluxRecords() {
        return this.records.stream().map(Record::getInfluxRecord).collect(Collectors.toList());
    }

    public void setRecords(List<Record> records) {
        this.records = records;
    }

    public static Records create(List<Record> records) {
        return new Records(records);
    }

    public static Records create(Record recordObj) {
        return new Records().addRecord(recordObj);
    }

    public static Records create(String recordObj) {
        return Records.create(Record.fromString(recordObj));
    }

    public Records addRecord(String recordObj) {
        this.records.add(Record.fromString(recordObj));
        return this;
    }

    public Records addRecord(Record recordObj) {
        this.records.add(recordObj);
        return this;
    }

    public String toString() {
        return "Records{records=" + String.valueOf(this.records) + "}";
    }
}

