/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.infinispan.embedded;

import org.apache.camel.Message;
import org.apache.camel.component.infinispan.InfinispanConfiguration;
import org.apache.camel.component.infinispan.InfinispanEndpoint;
import org.apache.camel.component.infinispan.InfinispanManager;
import org.apache.camel.component.infinispan.InfinispanProducer;
import org.apache.camel.component.infinispan.embedded.InfinispanEmbeddedConfiguration;
import org.apache.camel.component.infinispan.embedded.InfinispanEmbeddedEndpoint;
import org.apache.camel.component.infinispan.embedded.InfinispanEmbeddedManager;
import org.apache.camel.component.infinispan.embedded.InfinispanEmbeddedUtil;
import org.apache.camel.spi.InvokeOnHeader;
import org.infinispan.Cache;
import org.infinispan.query.dsl.Query;
import org.infinispan.stats.Stats;

public class InfinispanEmbeddedProducer
extends InfinispanProducer<InfinispanEmbeddedManager, InfinispanEmbeddedConfiguration> {
    public InfinispanEmbeddedProducer(InfinispanEmbeddedEndpoint endpoint, String cacheName, InfinispanEmbeddedManager manager, InfinispanEmbeddedConfiguration configuration) {
        super((InfinispanEndpoint)endpoint, cacheName, (InfinispanManager)manager, (InfinispanConfiguration)configuration);
    }

    @InvokeOnHeader(value="STATS")
    public void onStats(Message message) {
        Cache cache = (Cache)((InfinispanEmbeddedManager)this.getManager()).getCache(message, this.getCacheName(), Cache.class);
        Stats result = cache.getAdvancedCache().getStats();
        this.setResult(message, result);
    }

    @InvokeOnHeader(value="QUERY")
    public void onQuery(Message message) {
        Cache cache = (Cache)((InfinispanEmbeddedManager)this.getManager()).getCache(message, this.getCacheName(), Cache.class);
        Query<?> query = InfinispanEmbeddedUtil.buildQuery(this.getConfiguration(), (Cache<Object, Object>)cache, message);
        if (query != null) {
            this.setResult(message, query.execute().list());
        }
    }
}

