/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.infinispan.embedded;

import org.apache.camel.Category;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.infinispan.InfinispanComponent;
import org.apache.camel.component.infinispan.InfinispanConstants;
import org.apache.camel.component.infinispan.InfinispanEndpoint;
import org.apache.camel.component.infinispan.embedded.InfinispanEmbeddedComponent;
import org.apache.camel.component.infinispan.embedded.InfinispanEmbeddedConfiguration;
import org.apache.camel.component.infinispan.embedded.InfinispanEmbeddedConsumer;
import org.apache.camel.component.infinispan.embedded.InfinispanEmbeddedProducer;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriPath;

@UriEndpoint(firstVersion="2.13.0", scheme="infinispan-embedded", title="Infinispan Embedded", syntax="infinispan-embedded:cacheName", category={Category.CACHE, Category.CLUSTERING}, headersClass=InfinispanConstants.class)
public class InfinispanEmbeddedEndpoint
extends InfinispanEndpoint {
    @UriPath(description="The name of the cache to use. Use current to use the existing cache name from the currently configured cached manager. Or use default for the default cache manager name.")
    @Metadata(required=true)
    private final String cacheName;
    @UriParam
    private final InfinispanEmbeddedConfiguration configuration;

    public InfinispanEmbeddedEndpoint(String uri, String cacheName, InfinispanComponent component, InfinispanEmbeddedConfiguration configuration) {
        super(uri, (Component)component);
        this.cacheName = cacheName;
        this.configuration = configuration;
    }

    public InfinispanEmbeddedComponent getComponent() {
        return (InfinispanEmbeddedComponent)super.getComponent();
    }

    public Producer createProducer() throws Exception {
        return new InfinispanEmbeddedProducer(this, this.cacheName, this.getComponent().getManager(), this.configuration);
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        InfinispanEmbeddedConsumer consumer = new InfinispanEmbeddedConsumer(this, processor, this.cacheName, this.getComponent().getManager(), this.configuration);
        this.configureConsumer((Consumer)consumer);
        return consumer;
    }

    public String getCacheName() {
        return this.cacheName;
    }

    public InfinispanEmbeddedConfiguration getConfiguration() {
        return this.configuration;
    }
}

