/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.iec60870;

import java.util.Objects;
import java.util.TimeZone;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriParams;
import org.eclipse.neoscada.protocol.iec60870.ASDUAddressType;
import org.eclipse.neoscada.protocol.iec60870.CauseOfTransmissionType;
import org.eclipse.neoscada.protocol.iec60870.InformationObjectAddressType;
import org.eclipse.neoscada.protocol.iec60870.ProtocolOptions;

@UriParams
public abstract class BaseOptions<T extends BaseOptions<T>> {
    @UriParam(javaType="org.eclipse.neoscada.protocol.iec60870.ProtocolOptions")
    private ProtocolOptions.Builder protocolOptions;
    @UriParam(enums="SIZE_1, SIZE_2", label="connection")
    private ASDUAddressType adsuAddressType;
    @UriParam(enums="SIZE_1, SIZE_2, SIZE_3", label="connection")
    private InformationObjectAddressType informationObjectAddressType;
    @UriParam(enums="SIZE_1, SIZE_2", label="connection")
    private CauseOfTransmissionType causeOfTransmissionType;
    @UriParam(label="data", defaultValue="UTC")
    private TimeZone timeZone;
    @UriParam(label="data")
    private boolean ignoreDaylightSavingTime;
    @UriParam(label="connection", defaultValue="15000")
    private int timeout1;
    @UriParam(label="connection", defaultValue="10000")
    private int timeout2;
    @UriParam(label="connection", defaultValue="20000")
    private int timeout3;
    @UriParam(label="connection", defaultValue="15")
    private short maxUnacknowledged;
    @UriParam(label="connection", defaultValue="10")
    private short acknowledgeWindow;

    protected BaseOptions() {
        this.protocolOptions = new ProtocolOptions.Builder();
    }

    protected BaseOptions(ProtocolOptions protocolOptions) {
        Objects.requireNonNull(protocolOptions);
        this.protocolOptions = new ProtocolOptions.Builder(protocolOptions);
    }

    public void setProtocolOptions(ProtocolOptions protocolOptions) {
        Objects.requireNonNull(protocolOptions);
        this.protocolOptions = new ProtocolOptions.Builder(protocolOptions);
    }

    public ProtocolOptions getProtocolOptions() {
        return this.protocolOptions.build();
    }

    public abstract T copy();

    public int getTimeout1() {
        return this.protocolOptions.getTimeout1();
    }

    public void setTimeout1(int timeout1) {
        this.protocolOptions.setTimeout1(timeout1);
    }

    public int getTimeout2() {
        return this.protocolOptions.getTimeout2();
    }

    public void setTimeout2(int timeout2) {
        this.protocolOptions.setTimeout2(timeout2);
    }

    public int getTimeout3() {
        return this.protocolOptions.getTimeout3();
    }

    public void setTimeout3(int timeout3) {
        this.protocolOptions.setTimeout3(timeout3);
    }

    public short getAcknowledgeWindow() {
        return this.protocolOptions.getAcknowledgeWindow();
    }

    public void setAcknowledgeWindow(short acknowledgeWindow) {
        this.protocolOptions.setAcknowledgeWindow(acknowledgeWindow);
    }

    public short getMaxUnacknowledged() {
        return this.protocolOptions.getMaxUnacknowledged();
    }

    public void setMaxUnacknowledged(short maxUnacknowledged) {
        this.protocolOptions.setMaxUnacknowledged(maxUnacknowledged);
    }

    public ASDUAddressType getAdsuAddressType() {
        return this.protocolOptions.getAdsuAddressType();
    }

    public void setAdsuAddressType(ASDUAddressType adsuAddressType) {
        this.protocolOptions.setAdsuAddressType(adsuAddressType);
    }

    public InformationObjectAddressType getInformationObjectAddressType() {
        return this.protocolOptions.getInformationObjectAddressType();
    }

    public void setInformationObjectAddressType(InformationObjectAddressType informationObjectAddressType) {
        this.protocolOptions.setInformationObjectAddressType(informationObjectAddressType);
    }

    public CauseOfTransmissionType getCauseOfTransmissionType() {
        return this.protocolOptions.getCauseOfTransmissionType();
    }

    public void setCauseOfTransmissionType(CauseOfTransmissionType causeOfTransmissionType) {
        this.protocolOptions.setCauseOfTransmissionType(causeOfTransmissionType);
    }

    public TimeZone getTimeZone() {
        return this.protocolOptions.getTimeZone();
    }

    public void setTimeZone(TimeZone timeZone) {
        this.protocolOptions.setTimeZone(timeZone);
    }

    public void setIgnoreDaylightSavingTime(boolean ignoreDaylightSavingTime) {
        this.protocolOptions.setIgnoreDaylightSavingTime(ignoreDaylightSavingTime);
    }

    public boolean isIgnoreDaylightSavingTime() {
        return this.protocolOptions.isIgnoreDaylightSavingTime();
    }
}

