/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.huaweicloud.frs;

import com.huaweicloud.sdk.core.auth.BasicCredentials;
import com.huaweicloud.sdk.core.auth.ICredential;
import com.huaweicloud.sdk.core.http.HttpConfig;
import com.huaweicloud.sdk.core.utils.StringUtils;
import com.huaweicloud.sdk.frs.v2.FrsClient;
import com.huaweicloud.sdk.frs.v2.model.CompareFaceByBase64Request;
import com.huaweicloud.sdk.frs.v2.model.CompareFaceByBase64Response;
import com.huaweicloud.sdk.frs.v2.model.CompareFaceByFileRequest;
import com.huaweicloud.sdk.frs.v2.model.CompareFaceByFileRequestBody;
import com.huaweicloud.sdk.frs.v2.model.CompareFaceByUrlRequest;
import com.huaweicloud.sdk.frs.v2.model.DetectFaceByBase64Request;
import com.huaweicloud.sdk.frs.v2.model.DetectFaceByBase64Response;
import com.huaweicloud.sdk.frs.v2.model.DetectFaceByFileRequest;
import com.huaweicloud.sdk.frs.v2.model.DetectFaceByFileRequestBody;
import com.huaweicloud.sdk.frs.v2.model.DetectFaceByUrlRequest;
import com.huaweicloud.sdk.frs.v2.model.DetectLiveByBase64Request;
import com.huaweicloud.sdk.frs.v2.model.DetectLiveByBase64Response;
import com.huaweicloud.sdk.frs.v2.model.DetectLiveByFileRequest;
import com.huaweicloud.sdk.frs.v2.model.DetectLiveByFileRequestBody;
import com.huaweicloud.sdk.frs.v2.model.DetectLiveByUrlRequest;
import com.huaweicloud.sdk.frs.v2.model.FaceCompareBase64Req;
import com.huaweicloud.sdk.frs.v2.model.FaceCompareUrlReq;
import com.huaweicloud.sdk.frs.v2.model.FaceDetectBase64Req;
import com.huaweicloud.sdk.frs.v2.model.FaceDetectUrlReq;
import com.huaweicloud.sdk.frs.v2.model.LiveDetectBase64Req;
import com.huaweicloud.sdk.frs.v2.model.LiveDetectUrlReq;
import com.huaweicloud.sdk.frs.v2.region.FrsRegion;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.component.huaweicloud.common.models.InputSourceType;
import org.apache.camel.component.huaweicloud.frs.FaceRecognitionEndpoint;
import org.apache.camel.component.huaweicloud.frs.models.ClientConfigurations;
import org.apache.camel.support.DefaultProducer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FaceRecognitionProducer
extends DefaultProducer {
    private static final Logger LOG = LoggerFactory.getLogger(FaceRecognitionProducer.class);
    private FrsClient frsClient;
    private FaceRecognitionEndpoint endpoint;

    public FaceRecognitionProducer(FaceRecognitionEndpoint endpoint) {
        super((Endpoint)endpoint);
        this.endpoint = endpoint;
    }

    public void process(Exchange exchange) {
        String operation;
        ClientConfigurations clientConfigurations = this.initializeConfigurations(this.endpoint);
        if (this.frsClient == null) {
            this.initializeSdkClient(this.endpoint, clientConfigurations);
        }
        if (StringUtils.isEmpty((CharSequence)(operation = this.endpoint.getOperation()))) {
            throw new IllegalStateException("operation cannot be empty");
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Performing frs operation: {}", (Object)operation);
        }
        switch (operation) {
            case "faceDetection": {
                this.performFaceDetectionOperation(exchange, clientConfigurations);
                break;
            }
            case "faceVerification": {
                this.performFaceVerificationOperation(exchange, clientConfigurations);
                break;
            }
            case "faceLiveDetection": {
                this.performLiveDetectOperation(exchange, clientConfigurations);
                break;
            }
            default: {
                throw new UnsupportedOperationException("operation needs to be faceDetection, faceVerification or faceLiveDetection");
            }
        }
    }

    private ClientConfigurations initializeConfigurations(FaceRecognitionEndpoint endpoint) {
        ClientConfigurations clientConfigurations = new ClientConfigurations();
        clientConfigurations.setAccessKey(this.getAccessKey(endpoint));
        clientConfigurations.setSecretKey(this.getSecretKey(endpoint));
        clientConfigurations.setProjectId(this.getProjectId(endpoint));
        clientConfigurations.setEndpoint(this.getEndpoint(endpoint));
        if (StringUtils.isEmpty((CharSequence)endpoint.getOperation())) {
            throw new IllegalArgumentException("operation needs to be set");
        }
        clientConfigurations.setIgnoreSslVerification(endpoint.isIgnoreSslVerification());
        if (clientConfigurations.isIgnoreSslVerification()) {
            LOG.warn("SSL verification is ignored. This is unsafe in production environment");
        }
        if (!StringUtils.isEmpty((CharSequence)endpoint.getProxyHost())) {
            clientConfigurations.setProxyHost(endpoint.getProxyHost());
            clientConfigurations.setProxyPort(endpoint.getProxyPort());
            clientConfigurations.setProxyUser(endpoint.getProxyUser());
            clientConfigurations.setProxyPassword(endpoint.getProxyPassword());
        }
        return clientConfigurations;
    }

    private void initializeSdkClient(FaceRecognitionEndpoint endpoint, ClientConfigurations clientConfigurations) {
        if (endpoint.getFrsClient() != null) {
            LOG.info("Instance of FrsClient was set on the endpoint. Skip creation of FrsClient from endpoint parameters");
            this.frsClient = endpoint.getFrsClient();
            return;
        }
        HttpConfig httpConfig = HttpConfig.getDefaultHttpConfig().withIgnoreSSLVerification(clientConfigurations.isIgnoreSslVerification());
        if (!StringUtils.isEmpty((CharSequence)clientConfigurations.getProxyHost())) {
            httpConfig.setProxyHost(clientConfigurations.getProxyHost());
            httpConfig.setProxyPort(clientConfigurations.getProxyPort());
            if (!StringUtils.isEmpty((CharSequence)clientConfigurations.getProxyUser())) {
                httpConfig.setProxyUsername(clientConfigurations.getProxyUser());
                httpConfig.setProxyPassword(clientConfigurations.getProxyPassword());
            }
        }
        BasicCredentials credentials = ((BasicCredentials)((BasicCredentials)new BasicCredentials().withAk(clientConfigurations.getAccessKey())).withSk(clientConfigurations.getSecretKey())).withProjectId(clientConfigurations.getProjectId());
        this.frsClient = (FrsClient)FrsClient.newBuilder().withCredential((ICredential)credentials).withHttpConfig(httpConfig).withEndpoint(clientConfigurations.getEndpoint()).build();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Successfully initialized FRS client");
        }
    }

    private void performFaceDetectionOperation(Exchange exchange, ClientConfigurations clientConfigurations) {
        DetectFaceByBase64Response result;
        this.updateFaceDetectionConfigurations(exchange, clientConfigurations);
        switch (clientConfigurations.getInputSourceType()) {
            case BASE64: {
                FaceDetectBase64Req base64ReqBody = new FaceDetectBase64Req().withImageBase64(clientConfigurations.getImageBase64());
                result = this.frsClient.detectFaceByBase64(new DetectFaceByBase64Request().withBody(base64ReqBody));
                break;
            }
            case URL: {
                FaceDetectUrlReq urlReqBody = new FaceDetectUrlReq().withImageUrl(clientConfigurations.getImageUrl());
                result = this.frsClient.detectFaceByUrl(new DetectFaceByUrlRequest().withBody(urlReqBody));
                break;
            }
            default: {
                try (FileInputStream inputStream = new FileInputStream(clientConfigurations.getImageFilePath());){
                    DetectFaceByFileRequestBody fileReqBody = new DetectFaceByFileRequestBody().withImageFile((InputStream)inputStream, this.getFileName(clientConfigurations.getImageFilePath()));
                    result = this.frsClient.detectFaceByFile(new DetectFaceByFileRequest().withBody(fileReqBody));
                    break;
                }
                catch (IOException e) {
                    throw new IllegalArgumentException(String.format("Image file path is invalid: %s", clientConfigurations.getImageFilePath()));
                }
            }
        }
        exchange.getMessage().setBody((Object)result);
    }

    private void performFaceVerificationOperation(Exchange exchange, ClientConfigurations clientConfigurations) {
        CompareFaceByBase64Response result;
        this.updateFaceVerificationConfigurations(exchange, clientConfigurations);
        switch (clientConfigurations.getInputSourceType()) {
            case BASE64: {
                FaceCompareBase64Req base64ReqBody = new FaceCompareBase64Req().withImage1Base64(clientConfigurations.getImageBase64()).withImage2Base64(clientConfigurations.getAnotherImageBase64());
                result = this.frsClient.compareFaceByBase64(new CompareFaceByBase64Request().withBody(base64ReqBody));
                break;
            }
            case URL: {
                FaceCompareUrlReq urlReqBody = new FaceCompareUrlReq().withImage1Url(clientConfigurations.getImageUrl()).withImage2Url(clientConfigurations.getAnotherImageUrl());
                result = this.frsClient.compareFaceByUrl(new CompareFaceByUrlRequest().withBody(urlReqBody));
                break;
            }
            default: {
                try (FileInputStream image1InputStream = new FileInputStream(clientConfigurations.getImageFilePath());
                     FileInputStream image2InputStream = new FileInputStream(clientConfigurations.getAnotherImageFilePath());){
                    CompareFaceByFileRequestBody fileReqBody = new CompareFaceByFileRequestBody().withImage1File((InputStream)image1InputStream, this.getFileName(clientConfigurations.getImageFilePath())).withImage2File((InputStream)image2InputStream, this.getFileName(clientConfigurations.getAnotherImageFilePath()));
                    result = this.frsClient.compareFaceByFile(new CompareFaceByFileRequest().withBody(fileReqBody));
                    break;
                }
                catch (IOException e) {
                    throw new IllegalArgumentException(String.format("Image file paths are invalid: %s, %s", clientConfigurations.getImageFilePath(), clientConfigurations.getAnotherImageFilePath()));
                }
            }
        }
        exchange.getMessage().setBody((Object)result);
    }

    private void performLiveDetectOperation(Exchange exchange, ClientConfigurations clientConfigurations) {
        DetectLiveByBase64Response result;
        this.updateLiveDetectConfigurations(exchange, clientConfigurations);
        switch (clientConfigurations.getInputSourceType()) {
            case BASE64: {
                LiveDetectBase64Req base64ReqBody = new LiveDetectBase64Req().withVideoBase64(clientConfigurations.getVideoBase64()).withActions(clientConfigurations.getActions()).withActionTime(clientConfigurations.getActionTimes());
                result = this.frsClient.detectLiveByBase64(new DetectLiveByBase64Request().withBody(base64ReqBody));
                break;
            }
            case URL: {
                LiveDetectUrlReq urlReqBody = new LiveDetectUrlReq().withVideoUrl(clientConfigurations.getVideoUrl()).withActions(clientConfigurations.getActions()).withActionTime(clientConfigurations.getActionTimes());
                result = this.frsClient.detectLiveByUrl(new DetectLiveByUrlRequest().withBody(urlReqBody));
                break;
            }
            default: {
                try (FileInputStream inputStream = new FileInputStream(clientConfigurations.getVideoFilePath());){
                    DetectLiveByFileRequestBody fileReqBody = new DetectLiveByFileRequestBody().withVideoFile((InputStream)inputStream, this.getFileName(clientConfigurations.getVideoFilePath())).withActions(clientConfigurations.getActions()).withActionTime(clientConfigurations.getActionTimes());
                    result = this.frsClient.detectLiveByFile(new DetectLiveByFileRequest().withBody(fileReqBody));
                    break;
                }
                catch (IOException e) {
                    throw new IllegalArgumentException(String.format("Video file path is invalid: %s", clientConfigurations.getVideoFilePath()));
                }
            }
        }
        exchange.getMessage().setBody((Object)result);
    }

    private String getFileName(String filePath) {
        return new File(filePath).getName();
    }

    private void updateFaceDetectionConfigurations(Exchange exchange, ClientConfigurations clientConfigurations) {
        String imageBase64 = (String)exchange.getProperty("CamelHwCloudFrsImageBase64", String.class);
        clientConfigurations.setImageBase64(StringUtils.isEmpty((CharSequence)imageBase64) ? this.endpoint.getImageBase64() : imageBase64);
        if (!StringUtils.isEmpty((CharSequence)clientConfigurations.getImageBase64())) {
            clientConfigurations.setInputSourceType(InputSourceType.BASE64);
            return;
        }
        String imageUrl = (String)exchange.getProperty("CamelHwCloudFrsImageUrl", String.class);
        clientConfigurations.setImageUrl(StringUtils.isEmpty((CharSequence)imageUrl) ? this.endpoint.getImageUrl() : imageUrl);
        if (!StringUtils.isEmpty((CharSequence)clientConfigurations.getImageUrl())) {
            clientConfigurations.setInputSourceType(InputSourceType.URL);
            return;
        }
        String imageFilePath = (String)exchange.getProperty("CamelHwCloudFrsImageFilePath", String.class);
        clientConfigurations.setImageFilePath(StringUtils.isEmpty((CharSequence)imageFilePath) ? this.endpoint.getImageFilePath() : imageFilePath);
        if (!StringUtils.isEmpty((CharSequence)clientConfigurations.getImageFilePath())) {
            clientConfigurations.setInputSourceType(InputSourceType.FILE_PATH);
            return;
        }
        throw new IllegalArgumentException("any one of image base64, url and filePath needs to be set");
    }

    private void updateFaceVerificationConfigurations(Exchange exchange, ClientConfigurations clientConfigurations) {
        String image1Base64 = (String)exchange.getProperty("CamelHwCloudFrsImageBase64", String.class);
        String image2Base64 = (String)exchange.getProperty("CamelHwCloudFrsAnotherImageBase64", String.class);
        clientConfigurations.setImageBase64(StringUtils.isEmpty((CharSequence)image1Base64) ? this.endpoint.getImageBase64() : image1Base64);
        clientConfigurations.setAnotherImageBase64(StringUtils.isEmpty((CharSequence)image2Base64) ? this.endpoint.getAnotherImageBase64() : image2Base64);
        if (!StringUtils.isEmpty((CharSequence)clientConfigurations.getImageBase64()) && !StringUtils.isEmpty((CharSequence)clientConfigurations.getAnotherImageBase64())) {
            clientConfigurations.setInputSourceType(InputSourceType.BASE64);
            return;
        }
        String image1Url = (String)exchange.getProperty("CamelHwCloudFrsImageUrl", String.class);
        String image2Url = (String)exchange.getProperty("CamelHwCloudFrsAnotherImageUrl", String.class);
        clientConfigurations.setImageUrl(StringUtils.isEmpty((CharSequence)image1Url) ? this.endpoint.getImageUrl() : image1Url);
        clientConfigurations.setAnotherImageUrl(StringUtils.isEmpty((CharSequence)image2Url) ? this.endpoint.getAnotherImageUrl() : image2Url);
        if (!StringUtils.isEmpty((CharSequence)clientConfigurations.getImageUrl()) && !StringUtils.isEmpty((CharSequence)clientConfigurations.getAnotherImageUrl())) {
            clientConfigurations.setInputSourceType(InputSourceType.URL);
            return;
        }
        String image1FilePath = (String)exchange.getProperty("CamelHwCloudFrsImageFilePath", String.class);
        String image2FilePath = (String)exchange.getProperty("CamelHwCloudFrsAnotherImageFilePath", String.class);
        clientConfigurations.setImageFilePath(StringUtils.isEmpty((CharSequence)image1FilePath) ? this.endpoint.getImageFilePath() : image1FilePath);
        clientConfigurations.setAnotherImageFilePath(StringUtils.isEmpty((CharSequence)image2FilePath) ? this.endpoint.getAnotherImageFilePath() : image2FilePath);
        if (!StringUtils.isEmpty((CharSequence)clientConfigurations.getImageFilePath()) && !StringUtils.isEmpty((CharSequence)clientConfigurations.getAnotherImageFilePath())) {
            clientConfigurations.setInputSourceType(InputSourceType.FILE_PATH);
            return;
        }
        throw new IllegalArgumentException("any one of image base64, url and filePath needs to be set");
    }

    private void updateLiveDetectConfigurations(Exchange exchange, ClientConfigurations clientConfigurations) {
        this.updateVideoSource(exchange, clientConfigurations);
        String actions = (String)exchange.getProperty("CamelHwCloudFrsVideoActions", String.class);
        clientConfigurations.setActions(StringUtils.isEmpty((CharSequence)actions) ? this.endpoint.getActions() : actions);
        if (StringUtils.isEmpty((CharSequence)clientConfigurations.getActions())) {
            throw new IllegalArgumentException("actions needs to be set");
        }
        String actionTimes = (String)exchange.getProperty("CamelHwCloudFrsVideoActionTimes", String.class);
        clientConfigurations.setActionTimes(StringUtils.isEmpty((CharSequence)actionTimes) ? this.endpoint.getActionTimes() : actionTimes);
    }

    private void updateVideoSource(Exchange exchange, ClientConfigurations clientConfigurations) {
        String videoBase64 = (String)exchange.getProperty("CamelHwCloudFrsVideoBase64", String.class);
        clientConfigurations.setVideoBase64(StringUtils.isEmpty((CharSequence)videoBase64) ? this.endpoint.getVideoBase64() : videoBase64);
        if (!StringUtils.isEmpty((CharSequence)clientConfigurations.getVideoBase64())) {
            clientConfigurations.setInputSourceType(InputSourceType.BASE64);
            return;
        }
        String videoUrl = (String)exchange.getProperty("CamelHwCloudFrsVideoUrl", String.class);
        clientConfigurations.setVideoUrl(StringUtils.isEmpty((CharSequence)videoUrl) ? this.endpoint.getVideoUrl() : videoUrl);
        if (!StringUtils.isEmpty((CharSequence)clientConfigurations.getVideoUrl())) {
            clientConfigurations.setInputSourceType(InputSourceType.URL);
            return;
        }
        String videoFilePath = (String)exchange.getProperty("CamelHwCloudFrsVideoFilePath", String.class);
        clientConfigurations.setVideoFilePath(StringUtils.isEmpty((CharSequence)videoFilePath) ? this.endpoint.getVideoFilePath() : videoFilePath);
        if (!StringUtils.isEmpty((CharSequence)clientConfigurations.getVideoFilePath())) {
            clientConfigurations.setInputSourceType(InputSourceType.FILE_PATH);
            return;
        }
        throw new IllegalArgumentException("any one of video base64, url and filePath needs to be set");
    }

    private String getAccessKey(FaceRecognitionEndpoint endpoint) {
        if (!StringUtils.isEmpty((CharSequence)endpoint.getAccessKey())) {
            return endpoint.getAccessKey();
        }
        if (endpoint.getServiceKeys() != null && !StringUtils.isEmpty((CharSequence)endpoint.getServiceKeys().getAccessKey())) {
            return endpoint.getServiceKeys().getAccessKey();
        }
        throw new IllegalArgumentException("authentication parameter access key (AK) not found");
    }

    private String getSecretKey(FaceRecognitionEndpoint endpoint) {
        if (!StringUtils.isEmpty((CharSequence)endpoint.getSecretKey())) {
            return endpoint.getSecretKey();
        }
        if (endpoint.getServiceKeys() != null && !StringUtils.isEmpty((CharSequence)endpoint.getServiceKeys().getSecretKey())) {
            return endpoint.getServiceKeys().getSecretKey();
        }
        throw new IllegalArgumentException("authentication parameter secret key (SK) not found");
    }

    private String getProjectId(FaceRecognitionEndpoint endpoint) {
        if (StringUtils.isEmpty((CharSequence)endpoint.getProjectId())) {
            throw new IllegalArgumentException("Project id not found");
        }
        return endpoint.getProjectId();
    }

    private String getEndpoint(FaceRecognitionEndpoint endpoint) {
        if (!StringUtils.isEmpty((CharSequence)endpoint.getEndpoint())) {
            return endpoint.getEndpoint();
        }
        if (StringUtils.isEmpty((CharSequence)endpoint.getRegion())) {
            throw new IllegalArgumentException("either endpoint or region needs to be set");
        }
        return FrsRegion.valueOf((String)endpoint.getRegion()).getEndpoint();
    }
}

